/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.utils.bytecode.holders;

import java.util.Arrays;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.NotFoundException;
import pt.digitalis.utils.CodeGenUtil4Javassist;
import pt.digitalis.utils.CodeGenUtils;
import pt.digitalis.utils.bytecode.exceptions.CodeGenerationException;
import pt.digitalis.utils.bytecode.holders.AnnotationHolder;
import pt.digitalis.utils.bytecode.holders.AttributeHolder;
import pt.digitalis.utils.bytecode.holders.HolderRepository;
import pt.digitalis.utils.bytecode.holders.MethodHolder;
import pt.digitalis.utils.inspection.exception.ResourceNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassHolder {
    private String classFQName;

    public ClassHolder(CtClass clazz) {
        if (!HolderRepository.classExists(clazz.getName())) {
            HolderRepository.addClass(clazz);
        }
        this.classFQName = clazz.getName();
    }

    public ClassHolder(String classFQName) throws ResourceNotFoundException {
        this(CodeGenUtil4Javassist.getClass(classFQName));
    }

    public void addInterface(ClassHolder interfaceClass) throws ResourceNotFoundException {
        this.update(CodeGenUtil4Javassist.addInterface(interfaceClass.getManagedClass(), this.getManagedClass()));
    }

    public void addMethod(String sourceCode) throws CodeGenerationException, ResourceNotFoundException {
        this.update(CodeGenUtil4Javassist.addMethodSourceToClass(sourceCode, this.getManagedClass()));
    }

    public void addOrReplaceMethod(String sourceCode) throws CodeGenerationException, ResourceNotFoundException {
        this.update(CodeGenUtil4Javassist.addMethodSourceToClass(sourceCode, this.getManagedClass(), true));
    }

    public void cleanUp() {
        try {
            this.getManagedClass().detach();
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            // empty catch block
        }
    }

    public boolean containsAnnotation(String annotationName) throws ResourceNotFoundException {
        return this.getAnnotations().containsKey(annotationName);
    }

    public boolean containsMethod(String methodName) throws ResourceNotFoundException {
        return this.getMethods().containsKey(methodName);
    }

    public void copyAllFromClass(ClassHolder sourceTemplate) throws CodeGenerationException, ResourceNotFoundException {
        CtClass enhancedClass = CodeGenUtil4Javassist.copyClassToClass(sourceTemplate.getManagedClass(), this.getManagedClass());
        this.update(enhancedClass);
    }

    public void copyMethodFromClass(ClassHolder sourceTemplate, String methodName) throws CodeGenerationException, ResourceNotFoundException {
        CtClass enhancedClass = CodeGenUtil4Javassist.copyClassMethod(sourceTemplate.getManagedClass(), this.getManagedClass(), methodName);
        this.update(enhancedClass);
    }

    public void deleteClassFromRepository() throws ResourceNotFoundException {
        HolderRepository.deleteClassAndReferences(this.getUniqueID());
        this.classFQName = null;
    }

    public String generateID() throws ResourceNotFoundException {
        return CodeGenUtils.generateID(this.getName());
    }

    public Map<String, MethodHolder> getAllMethods() throws ResourceNotFoundException {
        Map<String, MethodHolder> classMethods = HolderRepository.getMethods(this.getUniqueID());
        if (classMethods == null) {
            classMethods = CodeGenUtil4Javassist.getTypeMethods(this, true);
            HolderRepository.addMethods(this.getUniqueID(), classMethods);
        }
        return classMethods;
    }

    public Map<String, AnnotationHolder> getAnnotations() throws ResourceNotFoundException {
        Map<String, AnnotationHolder> classAnnotations = HolderRepository.getAnnotations(this.getUniqueID());
        if (classAnnotations == null) {
            classAnnotations = CodeGenUtil4Javassist.getTypeAnnotations(this);
            HolderRepository.addAnnotations(this.getUniqueID(), classAnnotations);
        }
        return classAnnotations;
    }

    public Map<String, AttributeHolder> getAttributes() throws ResourceNotFoundException {
        Map<String, AttributeHolder> classAttributes = HolderRepository.getAttributes(this.getUniqueID());
        if (classAttributes == null) {
            classAttributes = CodeGenUtil4Javassist.getTypeFields(this);
            HolderRepository.addAttributes(this.getUniqueID(), classAttributes);
        }
        return classAttributes;
    }

    public Object getClassInstance() throws ClassNotFoundException, InstantiationException, IllegalAccessException, ResourceNotFoundException {
        return this.getManagedClass().getClassPool().getClassLoader().loadClass(this.classFQName).newInstance();
    }

    public String getFQName() {
        return this.classFQName;
    }

    public CtClass getManagedClass() throws ResourceNotFoundException {
        return HolderRepository.getClass(this.classFQName);
    }

    public Map<String, MethodHolder> getMethods() throws ResourceNotFoundException {
        Map<String, MethodHolder> classMethods = HolderRepository.getMethods(this.getUniqueID());
        if (classMethods == null) {
            classMethods = CodeGenUtil4Javassist.getTypeMethods(this, false);
            HolderRepository.addMethods(this.getUniqueID(), classMethods);
        }
        return classMethods;
    }

    public String getName() throws ResourceNotFoundException {
        return HolderRepository.getClass(this.classFQName).getSimpleName();
    }

    public String getPackageName() throws ResourceNotFoundException {
        return HolderRepository.getClass(this.classFQName).getPackageName();
    }

    public String getSuperClass() throws ResourceNotFoundException {
        try {
            return this.getManagedClass().getSuperclass().getName();
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    public String getUniqueID() throws ResourceNotFoundException {
        return this.getFQName();
    }

    public boolean hasInterface(String interfaceName) throws ResourceNotFoundException {
        return Arrays.asList(this.getManagedClass().getClassFile2().getInterfaces()).contains(interfaceName);
    }

    public void setSuperClass(CtClass superClass) throws CannotCompileException, ResourceNotFoundException {
        this.getManagedClass().setSuperclass(superClass);
    }

    public void setSuperClass(String superClassName) throws CannotCompileException, ResourceNotFoundException {
        CodeGenUtil4Javassist.setSuperClass(this.getFQName(), superClassName);
    }

    public void update(CtClass clazz) {
        try {
            HolderRepository.deleteClassAndReferences(this.getUniqueID());
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            // empty catch block
        }
        this.classFQName = clazz.getName();
        HolderRepository.updateClass(clazz);
    }

    public void updateMethodSource(String methodName, String sourceCode) throws CodeGenerationException, ResourceNotFoundException {
        MethodHolder method = this.getMethods().get(methodName);
        method.updateSource(sourceCode);
    }

    public Class<?> writeClass() throws CodeGenerationException, ResourceNotFoundException {
        return CodeGenUtil4Javassist.writeClass(this.getManagedClass());
    }
}

