/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.utils.bytecode.holders;

import java.util.Map;
import javassist.CtMethod;
import pt.digitalis.utils.CodeGenUtil4Javassist;
import pt.digitalis.utils.bytecode.exceptions.CodeGenerationException;
import pt.digitalis.utils.bytecode.holders.AnnotationHolder;
import pt.digitalis.utils.bytecode.holders.ClassHolder;
import pt.digitalis.utils.bytecode.holders.HolderRepository;
import pt.digitalis.utils.inspection.exception.ResourceNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodHolder {
    private CtMethod method;
    private String parentClassName;

    public MethodHolder(ClassHolder clazz, CtMethod method) throws ResourceNotFoundException {
        this.parentClassName = clazz.getUniqueID();
        this.method = method;
    }

    public ClassHolder getParentClass() throws ResourceNotFoundException {
        return new ClassHolder(HolderRepository.getClass(this.parentClassName));
    }

    public String getUniqueID() {
        return this.parentClassName + "." + this.getName();
    }

    public String getParentClassName() {
        return this.parentClassName;
    }

    public String getName() {
        return this.method.getName();
    }

    public String getSignature() {
        return this.method.getSignature();
    }

    public Map<String, AnnotationHolder> getAnnotations() throws ResourceNotFoundException {
        Map<String, AnnotationHolder> methodAnnotations = HolderRepository.getAnnotations(this.getUniqueID());
        if (methodAnnotations == null) {
            methodAnnotations = CodeGenUtil4Javassist.getMethodAnnotations(this);
            HolderRepository.addAnnotations(this.getUniqueID(), methodAnnotations);
        }
        return methodAnnotations;
    }

    public boolean containsAnnotation(String annotationName) throws ResourceNotFoundException {
        return this.getAnnotations().containsKey(annotationName);
    }

    public void updateSource(String sourceCode) throws CodeGenerationException, ResourceNotFoundException {
        this.method = CodeGenUtil4Javassist.replaceMethodBody(sourceCode, this.getManagedMethod());
    }

    public void addAfterSource(String sourceCode) throws CodeGenerationException, ResourceNotFoundException {
        this.method = CodeGenUtil4Javassist.addCodeAfterMethodBody(sourceCode, this.getManagedMethod());
    }

    public void addBeforeSource(String sourceCode) throws CodeGenerationException, ResourceNotFoundException {
        this.method = CodeGenUtil4Javassist.addCodeBeforeMethodBody(sourceCode, this.getManagedMethod());
    }

    public CtMethod getManagedMethod() {
        return this.method;
    }

    public int getAccessFlags() {
        return this.method.getMethodInfo().getAccessFlags();
    }
}

