/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.utils;

/**
 * This class presents a set of general methods and constants to aid the code generation.
 *
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @created 2007/09/13
 */
public class CodeGenUtils
{

    /** The FQN separator character. */
    final static private char FQN_SEPARATOR = '.';

    /**
     * Generates an ID from a class's FQN. The ID is the lower-case version of the class's name.
     *
     * @param fullyQualifiedName the class's FQN
     *
     * @return an id for the class, which is the lower-case version of the class name.
     */
    static public String generateID(String fullyQualifiedName)
    {
        // Isolate the substring after the last dot (the class name)
        String id = fullyQualifiedName.substring(fullyQualifiedName.lastIndexOf(FQN_SEPARATOR) + 1);
        // Return the lower-case version of the class name
        return id.toLowerCase();
    }
}
