/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.utils.bytecode;

import java.util.Properties;

/**
 * This class represents the basic startup configuration ByteCode needs.
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @created Nov 23, 2007
 */
public class ByteCodeStartupConfiguration
{

    /** The name of the 'Properties' file storing the startup parameters. */
    final static public String CONFIGURATION_FILE = "bytecode.properties";

    /** The 'tracktimes' property tag. */
    final static private String TRACK_TIMES = "tracktimes";

    /** The 'showsource' property tag. */
    final static private String SHOW_SOURCE = "showsource";

    /** The F boolean value as a String. */
    final static private String FALSE = "false";

    /** The T boolean value as a String. */
    @SuppressWarnings("unused")
    final static private String TRUE = "true";

    /** Defines if the code generation times should be logged (property "tracktimes"). */
    static private boolean trackTimes;

    /** Defines if the source should be shown in code generation methods (property "showsource"). */
    static private boolean showSource;

    /** Static initializer. */
    static
    {

        Properties parameters = new Properties();

        try
        {
            /*
             * IMPLEMENTATION NOTE: Must use the Thread context class loader since inside Surefire the system
             * classLoader does not have all classpath entries
             */

            // Load the configuration file from the classPath
            parameters.load(Thread.currentThread().getContextClassLoader().getResourceAsStream(CONFIGURATION_FILE));
        }
        catch (Exception exception)
        {
            // If the file can't be loaded do nothing. The properties will be empty so the defaults will be picked up.
        }

        trackTimes = Boolean.parseBoolean(loadProperty(parameters, TRACK_TIMES, FALSE).toLowerCase());
        showSource = Boolean.parseBoolean(loadProperty(parameters, SHOW_SOURCE, FALSE).toLowerCase());
    }

    /**
     * Searches 'properties' for a given key and returns the appropriate value, or a default if supplied.
     *
     * @param prop         the Properties to search
     * @param key          the key to search
     * @param defaultValue the default value when none is found
     *
     * @return the read value of the default if not found
     */
    static String loadProperty(Properties prop, String key, String defaultValue)
    {
        String value = prop.getProperty(key);

        if (value == null)
            return defaultValue;
        else
            return value;
    }

    /**
     * Inspector for the 'trackTimes' member.
     *
     * @return the defined trackTimes value
     */
    public static boolean isTrackTimes()
    {
        return trackTimes;
    }

    /**
     * Inspector for the 'showSource' member.
     *
     * @return the showSource value
     */
    public static boolean isShowSource()
    {
        return showSource;
    }
}
