/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.utils.bytecode.holders;

import javassist.bytecode.annotation.AnnotationMemberValue;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import pt.digitalis.utils.CodeGenUtil4Javassist;
import pt.digitalis.utils.inspection.exception.ResourceNotFoundException;

import java.util.ArrayList;
import java.util.List;

/**
 * An helper class that helps to manage the temporary annotation member values in the code generation process. Provides
 * managing methods and cache the details read from the member.
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @created Sep 23, 2007
 */
public class AnnotationMemberValueHolder
{

    /** The member value object. */
    private MemberValue memberValue;

    /**
     * Constructs a new holder from a received a member value object.
     *
     * @param memberValue the member value to manage
     */
    public AnnotationMemberValueHolder(MemberValue memberValue)
    {
        this.memberValue = memberValue;
    }

    /**
     * Returns the member value from an enumeration value as a String.
     *
     * @return a String representation of the enumeration memberValue
     */
    public String enumValuetoString()
    {
        if (memberValue != null)
            return CodeGenUtil4Javassist.getEnumValue(memberValue);
        else
            return null;
    }

    /**
     * Returns the annotation value object.
     *
     * @return the annotation value object
     */
    public MemberValue getManagedAnnotationValue()
    {
        return this.memberValue;
    }

    /**
     * Returns the member value as an annotation list
     *
     * @param attribute the attribute holder for the inner annotations
     *
     * @return a List representation of the memberValue
     */
    public List<AnnotationHolder> toAnnotationList(AttributeHolder attribute)
    {
        List<AnnotationHolder> results = new ArrayList<AnnotationHolder>();

        ArrayMemberValue arrayValue = (ArrayMemberValue) getManagedAnnotationValue();

        for (MemberValue annotationValue : arrayValue.getValue())
        {
            results.add(new AnnotationHolder(attribute, ((AnnotationMemberValue) annotationValue).getValue(), true));
        }

        return results;
    }

    /**
     * Returns the member value as a Boolean.
     *
     * @param clazz the class holder for the inner annotations
     *
     * @return a Boolean representation of the memberValue
     *
     * @exception ResourceNotFoundException
     */
    public List<AnnotationHolder> toAnnotationList(ClassHolder clazz) throws ResourceNotFoundException
    {
        List<AnnotationHolder> results = new ArrayList<AnnotationHolder>();

        ArrayMemberValue arrayValue = (ArrayMemberValue) getManagedAnnotationValue();

        for (MemberValue annotationValue : arrayValue.getValue())
        {
            results.add(new AnnotationHolder(clazz, ((AnnotationMemberValue) annotationValue).getValue(), true));
        }

        return results;
    }

    /**
     * Returns the member value as a Boolean.
     *
     * @return a Boolean representation of the memberValue
     */
    public Boolean toBoolean()
    {
        return CodeGenUtil4Javassist.convertMemberValueToBoolean(memberValue);
    }

    /**
     * Returns the member value as a String.
     *
     * @return a String representation of the memberValue
     */
    @Override
    public String toString()
    {
        return CodeGenUtil4Javassist.convertMemberValueToString(memberValue);
    }

    /**
     * Returns the member value as a String array.
     *
     * @return a String array representation of the memberValue
     */
    public String[] toStringArray()
    {
        ArrayMemberValue arrayValue = (ArrayMemberValue) getManagedAnnotationValue();

        if (arrayValue == null)
            return new String[0];
        else
        {
            String[] results = new String[arrayValue.getValue().length];
            int index = 0;

            for (MemberValue annotationValue : arrayValue.getValue())
            {
                results[index++] = ((StringMemberValue) annotationValue).getValue();
            }

            return results;
        }
    }
}
