/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.utils.config;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import pt.digitalis.log.Logger;
import pt.digitalis.utils.common.CollectionUtils;
import pt.digitalis.utils.common.DateUtils;
import pt.digitalis.utils.common.StringUtils;
import pt.digitalis.utils.config.ConfigItem;
import pt.digitalis.utils.config.IConfigurations;
import pt.digitalis.utils.config.annotations.ConfigDefault;
import pt.digitalis.utils.config.annotations.ConfigID;
import pt.digitalis.utils.config.annotations.ConfigIgnore;
import pt.digitalis.utils.config.annotations.ConfigKeyID;
import pt.digitalis.utils.config.annotations.ConfigLOVAjaxEvent;
import pt.digitalis.utils.config.annotations.ConfigLOVValues;
import pt.digitalis.utils.config.annotations.ConfigSectionID;
import pt.digitalis.utils.config.annotations.ConfigSectionIDGetter;
import pt.digitalis.utils.inspection.ReflectionUtils;
import pt.digitalis.utils.inspection.ResourceUtils;
import pt.digitalis.utils.inspection.exception.AuxiliaryOperationException;
import pt.digitalis.utils.inspection.exception.ResourceNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConfigurationsImpl
implements IConfigurations {
    protected static Map<String, Class<?>> cachedConfigurations = null;
    protected static List<String> cachedConfigurationsPackages = new ArrayList<String>();
    public static final String DEFAULT_VALUE_KEYWORK = "#DefaultValue#";
    private static String generalConfigurationPrefix = "";
    private static boolean prefixedConfigurationsActive = false;
    private static Map<String, List<String>> prefixException = new HashMap<String, List<String>>();

    public static void setGeneralPrefix(String configurationPrefix) {
        generalConfigurationPrefix = configurationPrefix;
    }

    public AbstractConfigurationsImpl() {
        Properties props = this.readConfiguration("Configurations", "General", false);
        prefixedConfigurationsActive = Boolean.parseBoolean(props.getProperty("PrefixedConfigurationsActive", "false"));
        props.put("PrefixedConfigurationsActive", (Object)prefixedConfigurationsActive);
        this.writeConfiguration("Configurations", "General", props, false);
        props = this.readConfiguration("Configurations", "PrefixExceptions", false);
        for (Map.Entry<Object, Object> property : props.entrySet()) {
            if (property.getKey() == null || property.getValue() == null) continue;
            String prefix = property.getKey().toString();
            String[] exceptions = property.getValue().toString().split(",");
            prefixException.put(prefix, Arrays.asList(exceptions));
        }
    }

    public AbstractConfigurationsImpl(boolean forcePrefixedConfigurationsActive) {
        this();
        prefixedConfigurationsActive = true;
    }

    @Override
    public Map<String, Class<?>> getCacheConfigurationPoints() {
        if (cachedConfigurations == null) {
            this.readAllConfigurationsPoints();
        }
        return cachedConfigurations;
    }

    public String getConfigID(Class<?> clazz) {
        ConfigID configAnnotation = clazz.getAnnotation(ConfigID.class);
        if (configAnnotation == null) {
            return null;
        }
        return configAnnotation.value();
    }

    @Override
    public List<ConfigItem> getConfigItemsMap(Class<?> clazz) {
        ArrayList<ConfigItem> configItems = new ArrayList<ConfigItem>();
        for (Method method : clazz.getMethods()) {
            if (method.getDeclaringClass() != clazz || !method.getName().startsWith("get") && !method.getName().startsWith("is") || method.isAnnotationPresent(ConfigIgnore.class)) continue;
            boolean booleanItem = method.getName().startsWith("is");
            Method getter = method;
            try {
                ConfigLOVAjaxEvent lovAjaxAnnotation;
                String key;
                Constructor<Object> constructor;
                Method setter = booleanItem ? ReflectionUtils.getMethod(clazz, (String)("set" + method.getName().substring(2))) : ReflectionUtils.getMethod(clazz, (String)("set" + method.getName().substring(3)));
                if (setter == null) {
                    throw new ResourceNotFoundException("Could not find setter method: set" + method.getName().substring(3) + " for " + clazz.getSimpleName());
                }
                if (setter.getParameterTypes().length != 1) {
                    Logger.getLogger().error((Object)("More than one parameter: method=" + setter.toGenericString()));
                    continue;
                }
                Class<Object> parameterClass = setter.getParameterTypes()[0];
                if (booleanItem && parameterClass != Boolean.TYPE && parameterClass != Boolean.class) {
                    Logger.getLogger().error((Object)("Prefix \"is\" for getter methods only allows for boolean attributes: method=" + setter.toGenericString()));
                    continue;
                }
                if (parameterClass == Integer.TYPE) {
                    parameterClass = Integer.class;
                } else if (parameterClass == Long.TYPE) {
                    parameterClass = Long.class;
                } else if (parameterClass == Double.TYPE) {
                    parameterClass = Double.class;
                } else if (parameterClass == Boolean.TYPE) {
                    parameterClass = Boolean.class;
                }
                try {
                    constructor = parameterClass.getConstructor(String.class);
                }
                catch (SecurityException e) {
                    constructor = null;
                }
                catch (NoSuchMethodException e) {
                    constructor = null;
                }
                if (constructor == null) {
                    System.err.println(method.getDeclaringClass() + "#" + method.getName());
                    Logger.getLogger().error((Object)("No constructor in the argument class for String value: method=" + setter.toGenericString()));
                    continue;
                }
                if (method.isAnnotationPresent(ConfigKeyID.class)) {
                    ConfigKeyID keyAnnotation = method.getAnnotation(ConfigKeyID.class);
                    key = keyAnnotation.value();
                } else {
                    String methodName = method.getName();
                    key = methodName.startsWith("is") ? method.getName().substring(2) : method.getName().substring(3);
                }
                ConfigDefault defaultValueAnnotation = method.getAnnotation(ConfigDefault.class);
                String defaultValue = defaultValueAnnotation == null ? null : defaultValueAnnotation.value();
                ConfigItem configItem = new ConfigItem(key, getter, setter, constructor, defaultValue, getter.getReturnType());
                ConfigLOVValues lovValuesAnnotation = method.getAnnotation(ConfigLOVValues.class);
                if (lovValuesAnnotation != null && StringUtils.isNotBlank((String)lovValuesAnnotation.value())) {
                    configItem.setLovValues(CollectionUtils.keyValueStringToMap((String)lovValuesAnnotation.value()));
                }
                if ((lovAjaxAnnotation = method.getAnnotation(ConfigLOVAjaxEvent.class)) != null && StringUtils.isNotBlank((String)lovAjaxAnnotation.value())) {
                    configItem.setLovAjaxEvent(lovAjaxAnnotation.value());
                }
                configItems.add(configItem);
            }
            catch (ResourceNotFoundException e) {
                Logger.getLogger().error((Object)e.getMessage());
            }
        }
        return configItems;
    }

    private String getConfigPath(Class<?> clazz) {
        String configID = this.getConfigID(clazz);
        String configSectionID = this.getConfigSectionID(clazz);
        if (configID != null) {
            if (configSectionID == null) {
                return configID;
            }
            return configID + "/" + configSectionID;
        }
        return null;
    }

    public String getConfigSectionID(Class<?> clazz) {
        ConfigSectionID sectionAnnotation = clazz.getAnnotation(ConfigSectionID.class);
        if (sectionAnnotation == null) {
            return null;
        }
        return sectionAnnotation.value();
    }

    public String getConfigSectionID(Object obj) {
        ConfigSectionID sectionAnnotation = obj.getClass().getAnnotation(ConfigSectionID.class);
        if (sectionAnnotation == null) {
            ConfigSectionIDGetter sectionMethodAnnotation = null;
            Method sectionMethod = null;
            for (Method method : obj.getClass().getMethods()) {
                sectionMethodAnnotation = method.getAnnotation(ConfigSectionIDGetter.class);
                if (sectionMethodAnnotation == null) continue;
                sectionMethod = method;
                break;
            }
            if (sectionMethod == null) {
                return null;
            }
            try {
                return ReflectionUtils.invokeMethod(sectionMethod, (Object)obj, (Object[])new Object[0]).toString();
            }
            catch (Exception e) {
                Logger.getLogger().error((Object)e.getMessage());
                return null;
            }
        }
        return sectionAnnotation.value();
    }

    @Override
    public String getGeneralPrefix() {
        return generalConfigurationPrefix;
    }

    protected boolean isPrefixedConfiguration(String configPath) {
        if (!this.isPrefixedConfigurationsActive()) {
            return false;
        }
        List<String> exceptions = prefixException.get(generalConfigurationPrefix);
        if (exceptions == null) {
            return true;
        }
        for (String exceptionPath : exceptions) {
            if (!configPath.startsWith(exceptionPath)) continue;
            return false;
        }
        return true;
    }

    public boolean isPrefixedConfigurationsActive() {
        return prefixedConfigurationsActive;
    }

    @Override
    public void readAllConfigurationsPoints() {
        cachedConfigurationsPackages.clear();
        if (cachedConfigurations == null) {
            cachedConfigurations = new HashMap();
        } else {
            cachedConfigurations.clear();
        }
        ArrayList<String> basePackages = new ArrayList<String>();
        for (Package pck : Package.getPackages()) {
            String basePackage = pck.getName().split("\\.", 2)[0];
            if (basePackages.contains(basePackage)) continue;
            basePackages.add(basePackage);
        }
        for (String basePackage : basePackages) {
            this.readConfigurationsPointsForPackage(basePackage);
        }
    }

    @Override
    public <T> T readConfiguration(Class<T> clazz) {
        if (clazz == null) {
            Logger.getLogger().error((Object)"The class cannot be null. Parse error!");
            return null;
        }
        String configID = this.getConfigID(clazz);
        String sectionID = this.getConfigSectionID(clazz);
        if (configID != null && sectionID != null) {
            return this.readConfiguration(configID, sectionID, clazz);
        }
        return null;
    }

    @Override
    public Properties readConfiguration(String configID, String sectionID) {
        return this.readConfiguration(configID, sectionID, this.isPrefixedConfiguration(configID + "/" + sectionID));
    }

    public abstract Properties readConfiguration(String var1, String var2, boolean var3);

    @Override
    public <T> T readConfiguration(String configID, String sectionID, Class<T> clazz) {
        Object obj;
        boolean mustUpdate = false;
        if (clazz == null) {
            Logger.getLogger().error((Object)"The class cannot be null. Parse error!");
            return null;
        }
        Properties props = this.readConfiguration(configID, sectionID);
        try {
            obj = ReflectionUtils.instantiateObjectFromClass(clazz);
        }
        catch (AuxiliaryOperationException e) {
            Logger.getLogger().error((Object)("Could not create the Configuration Instance:\n" + e.getMessage()));
            return null;
        }
        List<ConfigItem> configItems = this.getConfigItemsMap(clazz);
        for (ConfigItem item : configItems) {
            String value = props == null ? null : props.getProperty(item.getKey());
            if (value == null) {
                mustUpdate = true;
            }
            if (value == null || value.equalsIgnoreCase(DEFAULT_VALUE_KEYWORK)) {
                value = item.getDefaultValue();
            }
            if (StringUtils.isBlank((String)value)) continue;
            try {
                Object valueAsObject = "null".equals(value) ? null : (item.getItemClass() == Date.class ? DateUtils.stringToDate((String)value) : ReflectionUtils.instantiateObjectFromClass(item.getConstructor(), (Object[])new Object[]{value}));
                ReflectionUtils.invokeMethod((Method)item.getSetter(), (Object)obj, (Object[])new Object[]{valueAsObject});
            }
            catch (ParseException e) {
                Logger.getLogger().error((Object)("Could not convert to Date: \"" + value + "\"\n" + e.getMessage()));
                return null;
            }
            catch (AuxiliaryOperationException e) {
                Logger.getLogger().error((Object)("Could not call setter: " + item.getSetter().getName() + "\n" + e.getMessage()));
                return null;
            }
        }
        if (mustUpdate) {
            this.writeConfiguration(configID, sectionID, obj);
        }
        return (T)obj;
    }

    @Override
    public Map<String, String> readConfigurationAsMap(String configID, String sectionID) {
        Properties properties = this.readConfiguration(configID, sectionID);
        HashMap<String, String> propObj = new HashMap<String, String>();
        for (Object object : properties.keySet()) {
            propObj.put(object.toString(), properties.getProperty(object.toString()));
        }
        return propObj;
    }

    @Override
    public void readConfigurationsPointsForPackage(String basePackage) {
        if (basePackage == null || "".equals(basePackage)) {
            this.readAllConfigurationsPoints();
        } else if (cachedConfigurations == null) {
            cachedConfigurations = new HashMap();
            cachedConfigurationsPackages.clear();
        }
        if (!cachedConfigurationsPackages.contains(basePackage)) {
            Logger.getLogger().debug((Object)("Reading configurations for package: \"" + basePackage + "\""));
            try {
                List classes = ResourceUtils.getClassesInDeepPackage((String)basePackage);
                for (String className : classes) {
                    try {
                        Class<?> clazz = Class.forName(className);
                        String configPath = this.getConfigPath(clazz);
                        if (configPath == null) continue;
                        cachedConfigurations.put(configPath, clazz);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            cachedConfigurationsPackages.add(basePackage);
        }
    }

    @Override
    public boolean removeConfiguration(Object bean) throws Exception {
        if (bean == null) {
            Logger.getLogger().error((Object)"The bean cannot be null. Parse error!");
            return false;
        }
        String configID = this.getConfigID(bean.getClass());
        String sectionID = this.getConfigSectionID(bean);
        if (configID != null && sectionID != null) {
            return this.removeConfiguration(configID, sectionID);
        }
        return false;
    }

    @Override
    public boolean removeConfiguration(String configID, String sectionID) {
        return this.removeConfiguration(configID, sectionID, this.isPrefixedConfiguration(configID + "/" + sectionID));
    }

    public abstract boolean removeConfiguration(String var1, String var2, boolean var3);

    public boolean writeConfiguration(Object annotatedPojo) throws Exception {
        if (annotatedPojo == null) {
            Logger.getLogger().error((Object)"The pojo cannot be null. Parse error!");
            return false;
        }
        String configID = this.getConfigID(annotatedPojo.getClass());
        String sectionID = this.getConfigSectionID(annotatedPojo);
        if (configID != null && sectionID != null) {
            return this.writeConfiguration(configID, sectionID, annotatedPojo);
        }
        return false;
    }

    @Override
    public boolean writeConfiguration(String configID, String sectionID, Object bean) {
        if (bean == null) {
            Logger.getLogger().error((Object)"The bean cannot be null. Parse error!");
            return false;
        }
        Properties props = new Properties();
        List<ConfigItem> configItems = this.getConfigItemsMap(bean.getClass());
        try {
            for (ConfigItem item : configItems) {
                Object value = ReflectionUtils.invokeMethod((Method)item.getGetter(), (Object)bean, (Object[])new Object[0]);
                String valueString = "";
                if (value != null) {
                    valueString = item.getItemClass() == Date.class ? DateUtils.dateToString((Date)((Date)value)) : value.toString();
                }
                if (valueString.equals(item.getDefaultValue())) {
                    valueString = DEFAULT_VALUE_KEYWORK;
                }
                props.setProperty(item.getKey(), valueString);
            }
        }
        catch (AuxiliaryOperationException e) {
            return false;
        }
        return this.writeConfiguration(configID, sectionID, props);
    }

    @Override
    public boolean writeConfiguration(String configID, String sectionID, Properties values) {
        return this.writeConfiguration(configID, sectionID, values, this.isPrefixedConfiguration(configID + "/" + sectionID));
    }

    public abstract boolean writeConfiguration(String var1, String var2, Properties var3, boolean var4);

    @Override
    public boolean writeConfigurationFromMap(String configID, String sectionID, Map<String, String> values) {
        if (values == null) {
            Logger.getLogger().error((Object)"The values map cannot be null. Parse error!");
            return false;
        }
        Properties props = new Properties();
        for (Map.Entry<String, String> entrie : values.entrySet()) {
            props.put(entrie.getKey(), entrie.getValue());
        }
        return this.writeConfiguration(configID, sectionID, props);
    }
}

