/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.utils.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import pt.digitalis.log.Logger;
import pt.digitalis.utils.config.AbstractConfigurationsImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationsPreferencesImpl
extends AbstractConfigurationsImpl {
    public ConfigurationsPreferencesImpl() {
    }

    public ConfigurationsPreferencesImpl(boolean forcePrefixedConfigurationsActive) {
        super(forcePrefixedConfigurationsActive);
    }

    private String[] getChildrens(String configID, String sectionID) throws BackingStoreException {
        boolean usePrefix = this.isPrefixedConfiguration(configID + "/" + sectionID);
        if (usePrefix) {
            configID = this.getGeneralPrefix() + configID;
        }
        if (sectionID != null && !"".equals(sectionID)) {
            configID = configID + "/" + sectionID;
        }
        if (!configID.startsWith("/")) {
            configID = "/" + configID;
        }
        Preferences systemPrefs = this.getPreferences(configID);
        return systemPrefs.childrenNames();
    }

    @Override
    public String getGeneralPrefix() {
        return super.getGeneralPrefix() + "/";
    }

    private Preferences getPreferences(String configID) {
        String node = configID.replaceAll("_", "-");
        if (System.getProperty("os.name").equalsIgnoreCase("Mac OS X")) {
            return Preferences.userRoot().node(node);
        }
        return Preferences.systemRoot().node(node);
    }

    @Override
    public Map<String, Properties> readAllConfigurations(String configID, String sectionID) {
        HashMap<String, Properties> result = new HashMap<String, Properties>();
        boolean usePrefix = this.isPrefixedConfiguration(configID + "/" + sectionID);
        try {
            for (String name : this.getChildrens(configID, sectionID)) {
                result.put(name, this.readConfiguration(configID, name, usePrefix));
            }
        }
        catch (BackingStoreException e) {
            Logger.getLogger().error((Object)("Repository not available. Configuration not loaded.\n" + e.getMessage()));
        }
        return result;
    }

    @Override
    public <T> Map<String, T> readAllConfigurations(String configID, String sectionID, Class<T> clazz) {
        HashMap<String, T> result = new HashMap<String, T>();
        try {
            for (String name : this.getChildrens(configID, sectionID)) {
                result.put(name, this.readConfiguration(configID, sectionID + "/" + name, clazz));
            }
        }
        catch (BackingStoreException e) {
            Logger.getLogger().error((Object)("Repository not available. Configuration not loaded.\n" + e.getMessage()));
        }
        return result;
    }

    @Override
    public Properties readConfiguration(String configID, String sectionID, boolean usePrefix) {
        if (usePrefix) {
            configID = this.getGeneralPrefix() + configID;
        }
        if (sectionID != null && !"".equals(sectionID)) {
            configID = configID + "/" + sectionID;
        }
        if (!configID.startsWith("/")) {
            configID = "/" + configID;
        }
        Preferences systemPrefs = this.getPreferences(configID);
        Properties propObj = new Properties();
        try {
            systemPrefs.sync();
            StringBuffer out = new StringBuffer();
            for (String key : systemPrefs.keys()) {
                if (key == null || systemPrefs.get(key, null) == null) continue;
                propObj.put(key, systemPrefs.get(key, null));
                if (key.toLowerCase().contains("password")) {
                    out.append("  " + key + "=[*******]\n");
                    continue;
                }
                out.append("  " + key + "=[" + propObj.getProperty(key) + "]\n");
            }
            if (out.length() > 0) {
                Logger.getLogger().debug((Object)("Configuration " + configID + ":\n" + out.toString()));
            }
        }
        catch (BackingStoreException e) {
            Logger.getLogger().error((Object)("Repository not available. Configuration not loaded.\n" + e.getMessage()));
        }
        return propObj;
    }

    @Override
    public boolean removeConfiguration(String configID, String sectionID, boolean usePrefix) {
        if (usePrefix) {
            configID = this.getGeneralPrefix() + configID;
        }
        if (sectionID != null && !"".equals(sectionID)) {
            configID = configID + "/" + sectionID;
        }
        if (!configID.startsWith("/")) {
            configID = "/" + configID;
        }
        try {
            Preferences systemPrefs = this.getPreferences(configID);
            systemPrefs.removeNode();
            systemPrefs.flush();
        }
        catch (BackingStoreException e) {
            Logger.getLogger().error((Object)("Repository not available. Configuration not removed.\n" + e.getMessage()));
            return false;
        }
        return true;
    }

    @Override
    public boolean writeConfiguration(String configID, String sectionID, Properties values, boolean usePrefix) {
        if (usePrefix) {
            configID = this.getGeneralPrefix() + configID;
        }
        if (sectionID != null && !"".equals(sectionID)) {
            configID = configID + "/" + sectionID;
        }
        if (!configID.startsWith("/")) {
            configID = "/" + configID;
        }
        Preferences systemPrefs = this.getPreferences(configID);
        for (Map.Entry<Object, Object> entry : values.entrySet()) {
            if (entry.getValue() == null) continue;
            systemPrefs.put(entry.getKey().toString(), entry.getValue().toString());
        }
        try {
            systemPrefs.flush();
        }
        catch (BackingStoreException e) {
            Logger.getLogger().error((Object)("Repository not available. Configuration not saved.\n" + e.getMessage()));
            return false;
        }
        return true;
    }
}

