/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.utils.config.tests;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import junit.framework.TestCase;
import pt.digitalis.utils.config.ConfigurationException;
import pt.digitalis.utils.config.IConfigurations;
import pt.digitalis.utils.config.tests.ConfigsMockupAnnotatedPojo;
import pt.digitalis.utils.config.tests.ConfigsMockupPojo;

public abstract class AbstractConfigurationsSpecificImplTest
extends TestCase {
    private final Date sampleDate = new GregorianCalendar(2007, 10, 2).getTime();

    public AbstractConfigurationsSpecificImplTest() {
    }

    public AbstractConfigurationsSpecificImplTest(String name) {
        super(name);
    }

    protected abstract IConfigurations getImplementation() throws ConfigurationException;

    public void testDefaultRemoveConfigurationAnnotatedPojo() throws Exception {
        IConfigurations config = this.getImplementation();
        ConfigsMockupAnnotatedPojo pojo = new ConfigsMockupAnnotatedPojo();
        pojo.setName("Abraham Lincoln");
        pojo.setAddress("Washington DC - President's Street 1");
        config.writeConfiguration("TestConfigurations", "temporaryAnnotatedPojo", pojo);
        pojo = (ConfigsMockupAnnotatedPojo)config.readConfiguration("TestConfigurations", "temporaryAnnotatedPojo", pojo.getClass());
        AbstractConfigurationsSpecificImplTest.assertNotNull((Object)pojo);
        AbstractConfigurationsSpecificImplTest.assertTrue((boolean)pojo.getName().equals("Abraham Lincoln"));
        AbstractConfigurationsSpecificImplTest.assertTrue((boolean)pojo.getAddress().equals("Washington DC - President's Street 1"));
        AbstractConfigurationsSpecificImplTest.assertTrue((boolean)config.removeConfiguration("TestConfigurations", "temporaryAnnotatedPojo"));
        pojo = (ConfigsMockupAnnotatedPojo)config.readConfiguration("TestConfigurations", "temporaryAnnotatedPojo", pojo.getClass());
        AbstractConfigurationsSpecificImplTest.assertNotNull((Object)pojo);
        AbstractConfigurationsSpecificImplTest.assertNull((Object)pojo.getName());
        AbstractConfigurationsSpecificImplTest.assertTrue((boolean)pojo.getAddress().equals("Our little blue planet!"));
        AbstractConfigurationsSpecificImplTest.assertTrue((boolean)config.removeConfiguration(pojo));
        pojo = config.readConfiguration(ConfigsMockupAnnotatedPojo.class);
        AbstractConfigurationsSpecificImplTest.assertNotNull((Object)pojo);
        AbstractConfigurationsSpecificImplTest.assertNull((Object)pojo.getName());
        AbstractConfigurationsSpecificImplTest.assertTrue((boolean)pojo.getAddress().equals("Our little blue planet!"));
    }

    public void testReadAllConfigurations() throws Exception {
        IConfigurations config = this.getImplementation();
        AbstractConfigurationsSpecificImplTest.assertNotNull((Object)config);
        this.testWriteConfigurationAnnotatedPojo();
        this.testWriteConfigurationBean();
        this.testWriteConfigurationFromMap();
        this.testWriteConfigurationProperties();
        Map<String, Properties> confs = config.readAllConfigurations("TestConfigurations", "");
        AbstractConfigurationsSpecificImplTest.assertTrue((confs.size() > 4 ? 1 : 0) != 0);
        AbstractConfigurationsSpecificImplTest.assertTrue((boolean)confs.containsKey("annotatedPojo"));
        AbstractConfigurationsSpecificImplTest.assertTrue((boolean)confs.containsKey("bean"));
        AbstractConfigurationsSpecificImplTest.assertTrue((boolean)confs.containsKey("properties"));
        ConfigsMockupAnnotatedPojo annPojo = config.readConfiguration(ConfigsMockupAnnotatedPojo.class);
        annPojo.setName("Name#1");
        config.writeConfiguration("TestConfigurations", "annotatedPojoConfigs/1", annPojo);
        annPojo.setName("Name#2");
        config.writeConfiguration("TestConfigurations", "annotatedPojoConfigs/2", annPojo);
        Map<String, ConfigsMockupAnnotatedPojo> results = config.readAllConfigurations("TestConfigurations", "annotatedPojoConfigs", ConfigsMockupAnnotatedPojo.class);
        AbstractConfigurationsSpecificImplTest.assertNotNull(results);
        AbstractConfigurationsSpecificImplTest.assertEquals((int)results.size(), (int)2);
        AbstractConfigurationsSpecificImplTest.assertNotNull((Object)results.get("1"));
        AbstractConfigurationsSpecificImplTest.assertEquals((String)results.get("1").getName(), (String)"Name#1");
        AbstractConfigurationsSpecificImplTest.assertNotNull((Object)results.get("2"));
        AbstractConfigurationsSpecificImplTest.assertEquals((String)results.get("2").getName(), (String)"Name#2");
        System.out.println(results);
    }

    public void testReadConfigurationAnnotatedPojo() throws Exception {
        IConfigurations config = this.getImplementation();
        ConfigsMockupAnnotatedPojo pojo = new ConfigsMockupAnnotatedPojo();
        pojo.setName("Abraham Lincoln");
        pojo.setAddress("Washington DC - President's Street 1");
        pojo.setAge(300);
        config.writeConfiguration("TestConfigurations", "annotatedPojo", pojo);
        pojo = config.readConfiguration(ConfigsMockupAnnotatedPojo.class);
        Properties props = config.readConfiguration("TestConfigurations", "annotatedPojo");
        AbstractConfigurationsSpecificImplTest.assertNotNull((Object)pojo);
        AbstractConfigurationsSpecificImplTest.assertTrue((boolean)pojo.getName().equals("Abraham Lincoln"));
        AbstractConfigurationsSpecificImplTest.assertTrue((boolean)pojo.getAddress().equals("Washington DC - President's Street 1"));
        AbstractConfigurationsSpecificImplTest.assertTrue((pojo.getAge() == 300 ? 1 : 0) != 0);
        AbstractConfigurationsSpecificImplTest.assertTrue((boolean)props.getProperty("FullName").equals(pojo.getName()));
        AbstractConfigurationsSpecificImplTest.assertTrue((boolean)props.getProperty("Address").equals(pojo.getAddress()));
        AbstractConfigurationsSpecificImplTest.assertTrue((props.size() == 3 ? 1 : 0) != 0);
    }

    public void testReadConfigurationAsMap() throws ConfigurationException {
        IConfigurations config = this.getImplementation();
        Map<String, String> propsMap = config.readConfigurationAsMap("TestConfigurations", "properties");
        AbstractConfigurationsSpecificImplTest.assertNotNull(propsMap);
        AbstractConfigurationsSpecificImplTest.assertTrue((propsMap.size() == 10 ? 1 : 0) != 0);
        for (String key : propsMap.keySet()) {
            AbstractConfigurationsSpecificImplTest.assertTrue((boolean)propsMap.get(key).equals("value " + key));
        }
    }

    public void testReadConfigurationBean() throws Exception {
        IConfigurations config = this.getImplementation();
        ConfigsMockupPojo pojo = config.readConfiguration("TestConfigurations", "bean", ConfigsMockupPojo.class);
        AbstractConfigurationsSpecificImplTest.assertNotNull((Object)pojo);
        AbstractConfigurationsSpecificImplTest.assertTrue((boolean)pojo.getName().equals("Abraham Lincoln"));
        AbstractConfigurationsSpecificImplTest.assertTrue((boolean)pojo.getAddress().equals("Washington DC - President's Street 1"));
        AbstractConfigurationsSpecificImplTest.assertTrue((pojo.getAge() == 300 ? 1 : 0) != 0);
        AbstractConfigurationsSpecificImplTest.assertTrue((boolean)pojo.getBirthDate().equals(this.sampleDate));
        ConfigsMockupAnnotatedPojo annPojo = config.readConfiguration(ConfigsMockupAnnotatedPojo.class);
        AbstractConfigurationsSpecificImplTest.assertNotNull((Object)annPojo);
        AbstractConfigurationsSpecificImplTest.assertTrue((boolean)annPojo.getName().equals("Abraham Lincoln"));
        AbstractConfigurationsSpecificImplTest.assertTrue((boolean)annPojo.getAddress().equals("Washington DC - President's Street 1"));
        AbstractConfigurationsSpecificImplTest.assertTrue((annPojo.getAge() == 300 ? 1 : 0) != 0);
        Properties propsAnnPojo = config.readConfigurationAsProperties(ConfigsMockupAnnotatedPojo.class);
        AbstractConfigurationsSpecificImplTest.assertNotNull((Object)propsAnnPojo);
        AbstractConfigurationsSpecificImplTest.assertTrue((boolean)propsAnnPojo.getProperty("FullName").equals("Abraham Lincoln"));
        AbstractConfigurationsSpecificImplTest.assertTrue((boolean)propsAnnPojo.getProperty("Address").equals("Washington DC - President's Street 1"));
        AbstractConfigurationsSpecificImplTest.assertTrue((boolean)propsAnnPojo.getProperty("Age").equals("300"));
    }

    public void testReadConfigurationProperties() throws ConfigurationException {
        IConfigurations config = this.getImplementation();
        Properties props = config.readConfiguration("TestConfigurations", "properties");
        AbstractConfigurationsSpecificImplTest.assertNotNull((Object)props);
        AbstractConfigurationsSpecificImplTest.assertTrue((props.size() == 10 ? 1 : 0) != 0);
        for (Object key : props.keySet()) {
            AbstractConfigurationsSpecificImplTest.assertTrue((boolean)props.getProperty((String)key).equals("value " + key));
        }
    }

    public void testReadWriteConfigurationWithUnderScoreChar() throws ConfigurationException {
        IConfigurations config = this.getImplementation();
        Properties props = new Properties();
        String sectionID = "name_with_underscore";
        for (int i = 0; i < 10; ++i) {
            props.put(Integer.toString(i), "value " + i);
        }
        props.put("valueToReturn", "MyValue");
        AbstractConfigurationsSpecificImplTest.assertTrue((boolean)config.writeConfiguration("TestConfigurations", sectionID, props));
        props = config.readConfiguration("TestConfigurations", sectionID);
        AbstractConfigurationsSpecificImplTest.assertNotNull((Object)props);
        AbstractConfigurationsSpecificImplTest.assertEquals((String)props.getProperty("valueToReturn"), (String)"MyValue");
        AbstractConfigurationsSpecificImplTest.assertTrue((boolean)config.removeConfiguration("TestConfigurations", sectionID));
        props = config.readConfiguration("TestConfigurations", sectionID);
        AbstractConfigurationsSpecificImplTest.assertEquals((int)props.size(), (int)0);
    }

    public void testWriteConfigurationAnnotatedPojo() throws Exception {
        IConfigurations config = this.getImplementation();
        ConfigsMockupAnnotatedPojo pojo = new ConfigsMockupAnnotatedPojo();
        pojo.setName("Abraham Lincoln");
        pojo.setAddress("Washington DC - President's Street 1");
        pojo.setAge(300);
        AbstractConfigurationsSpecificImplTest.assertTrue((boolean)config.writeConfiguration(pojo));
    }

    public void testWriteConfigurationBean() throws Exception {
        IConfigurations config = this.getImplementation();
        ConfigsMockupPojo bean = new ConfigsMockupPojo();
        bean.setName("Abraham Lincoln");
        bean.setAddress("Washington DC - President's Street 1");
        bean.setAge(300);
        bean.setBirthDate(this.sampleDate);
        AbstractConfigurationsSpecificImplTest.assertTrue((boolean)config.writeConfiguration("TestConfigurations", "bean", bean));
    }

    public void testWriteConfigurationFromMap() throws ConfigurationException {
        IConfigurations config = this.getImplementation();
        HashMap<String, String> propsMap = new HashMap<String, String>();
        for (int i = 0; i < 10; ++i) {
            propsMap.put(Integer.toString(i), "value " + i);
        }
        AbstractConfigurationsSpecificImplTest.assertTrue((boolean)config.writeConfigurationFromMap("TestConfigurations", "properties", propsMap));
    }

    public void testWriteConfigurationProperties() throws ConfigurationException {
        IConfigurations config = this.getImplementation();
        Properties props = new Properties();
        for (int i = 0; i < 10; ++i) {
            props.put(Integer.toString(i), "value " + i);
        }
        AbstractConfigurationsSpecificImplTest.assertTrue((boolean)config.writeConfiguration("TestConfigurations", "properties", props));
        props = new Properties();
        props.setProperty("FullName", "NameForTesting");
        props.setProperty("Address", "AddressForTesting");
        props.setProperty("Age", "3");
        AbstractConfigurationsSpecificImplTest.assertTrue((boolean)config.writeConfiguration(ConfigsMockupAnnotatedPojo.class, props));
        ConfigsMockupAnnotatedPojo annPojo = config.readConfiguration(ConfigsMockupAnnotatedPojo.class);
        AbstractConfigurationsSpecificImplTest.assertNotNull((Object)annPojo);
        AbstractConfigurationsSpecificImplTest.assertEquals((String)annPojo.getName(), (String)"NameForTesting");
        AbstractConfigurationsSpecificImplTest.assertEquals((String)annPojo.getAddress(), (String)"AddressForTesting");
        AbstractConfigurationsSpecificImplTest.assertEquals((int)annPojo.getAge(), (int)3);
    }
}

