/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.utils.config;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;

/**
 * Utility class to keep a Config field/property key and accessor methods for reflection manipulation purposes
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @created Sep 27, 2007
 */
public class ConfigItem {

    /** The constructor for the setter argument */
    private Constructor<?> constructor;

    /** The default value for the item */
    private String defaultValue;

    /** The property description */
    private String description;

    /** The property getter method */
    private Method getter;

    /** The is private. */
    private boolean isPrivate;

    /** The class of the item */
    private Class<?> itemClazz;

    /** The property key */
    private String key;

    /** the list List of Values source AJAX event */
    private String lovAjaxEvent;

    /** the list List of Values source AJAX event */
    private Map<String, String> lovValues;

    /** The property name */
    private String name;

    /** The property setter method */
    private Method setter;

    /**
     * Default Constructor
     * 
     * @param key
     *            the property key
     * @param getter
     *            the property getter method
     * @param setter
     *            the property setter method
     * @param constructor
     *            the constructor for the value conversion of the setter value
     * @param defaultValue
     *            the default value for the item
     * @param clazz
     *            the item class
     */
    public ConfigItem(String key, Method getter, Method setter, Constructor<?> constructor, String defaultValue,
            Class<?> clazz)
    {
        this.key = key;
        this.getter = getter;
        this.setter = setter;
        this.constructor = constructor;
        this.defaultValue = defaultValue;
        this.itemClazz = clazz;
        this.isPrivate = false;
    }

    /**
     * @return the constructor
     */
    public Constructor<?> getConstructor()
    {
        return constructor;
    }

    /**
     * @return the defaultValue
     */
    public String getDefaultValue()
    {
        return defaultValue;
    }

    /**
     * @return the description
     */
    public String getDescription()
    {
        return description;
    }

    /**
     * @return the getter
     */
    public Method getGetter()
    {
        return getter;
    }

    /**
     * @return the itemClazz
     */
    public Class<?> getItemClass()
    {
        return itemClazz;
    }

    /**
     * @return the key
     */
    public String getKey()
    {
        return key;
    }

    /**
     * Inspector for the 'lovAjaxEvent' attribute.
     * 
     * @return the lovAjaxEvent value
     */
    public String getLovAjaxEvent()
    {
        return lovAjaxEvent;
    }

    /**
     * Inspector for the 'lovValues' attribute.
     * 
     * @return the lovValues value
     */
    public Map<String, String> getLovValues()
    {
        return lovValues;
    }

    /**
     * @return the name
     */
    public String getName()
    {
        return name;
    }

    /**
     * @return the setter
     */
    public Method getSetter()
    {
        return setter;
    }

    /**
     * Inspector for the 'isPrivate' attribute.
     *
     * @return the isPrivate value
     */
    public boolean isPrivate()
    {
        return isPrivate;
    }

    /**
     * @param description
     *            the description to set
     */
    public void setDescription(String description)
    {
        this.description = description;
    }

    /**
     * Modifier for the 'lovAjaxEvent' attribute.
     * 
     * @param lovAjaxEvent
     *            the new lovAjaxEvent value to set
     */
    public void setLovAjaxEvent(String lovAjaxEvent)
    {
        this.lovAjaxEvent = lovAjaxEvent;
    }

    /**
     * Modifier for the 'lovValues' attribute.
     * 
     * @param lovValues
     *            the new lovValues value to set
     */
    public void setLovValues(Map<String, String> lovValues)
    {
        this.lovValues = lovValues;
    }

    /**
     * @param name
     *            the name to set
     */
    public void setName(String name)
    {
        this.name = name;
    }

    /**
     * Modifier for the 'isPrivate' attribute.
     *
     * @param isPrivate
     *            the new isPrivate value to set
     */
    public void setPrivate(boolean isPrivate)
    {
        this.isPrivate = isPrivate;
    }
}
