/**
 * 2019, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 http://www.digitalis.pt
 */
package pt.digitalis.utils.config;

/**
 * Provides the current implementations of the {@link IConfigurations} API.
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created Apr 4, 2019
 */
public class ConfigurationsProvider {

    /** The configurations impl. */
    private static IConfigurations configurations = null;

    /**
     * Gets the configurations.
     *
     * @return the configurations
     * @throws ConfigurationException
     *             the configuration exception
     */
    public static IConfigurations getConfigurations() throws ConfigurationException
    {
        return getConfigurations(true);
    }

    /**
     * Gets the configurations.
     *
     * @param ignoreTestConfigurations
     *            the ignore test configurations
     * @return the configurations
     * @throws ConfigurationException
     *             the configuration exception
     */
    public static IConfigurations getConfigurations(boolean ignoreTestConfigurations) throws ConfigurationException
    {
        if (configurations == null)
            configurations = new ConfigurationsPreferencesImpl(ignoreTestConfigurations);

        return configurations;
    }

    /**
     * Sets the configurations.
     *
     * @param configurations
     *            the configurations to set
     */
    public static void setConfigurations(IConfigurations configurations)
    {
        ConfigurationsProvider.configurations = configurations;
    }
}
