/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.utils.config.tests;

import pt.digitalis.utils.config.annotations.ConfigDefault;
import pt.digitalis.utils.config.annotations.ConfigID;
import pt.digitalis.utils.config.annotations.ConfigIgnore;
import pt.digitalis.utils.config.annotations.ConfigKeyID;
import pt.digitalis.utils.config.annotations.ConfigSectionID;
import pt.digitalis.utils.config.annotations.ConfigTestClass;

/**
 * Simple annotated pojo class with a few attributes
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @author Rodrigo Goncalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @created Sep 29, 2007
 */
@ConfigID("TestConfigurations")
@ConfigSectionID("annotatedPojo")
@ConfigTestClass
public class ConfigsMockupAnnotatedPojo {

    /** Address */
    private String address;

    /** Age */
    private int age;

    /** Field to ignore. */
    private int fieldToIgnore;

    /** Name */
    private String name;

    /** The param to test creation with default value. */
    private Boolean paramToTestCreationWithDefaultValue;

    /**
     * @return the address
     */
    @ConfigDefault("Our little blue planet!")
    public String getAddress()
    {
        return address;
    }

    /**
     * @return the age
     */
    public int getAge()
    {
        return age;
    }

    /**
     * @return the fieldToIgnore
     */
    @ConfigIgnore
    public int getFieldToIgnore()
    {
        return this.fieldToIgnore;
    }

    /**
     * @return the name
     */
    @ConfigKeyID("FullName")
    public String getName()
    {
        return name;
    }

    /**
     * Inspector for the 'paramToTestCreationWithDefaultValue' attribute.
     *
     * @return the paramToTestCreationWithDefaultValue value
     */
    @ConfigDefault("true")
    public Boolean getParamToTestCreationWithDefaultValue()
    {
        return paramToTestCreationWithDefaultValue;
    }

    /**
     * @param address
     *            the address to set
     */
    public void setAddress(String address)
    {
        this.address = address;
    }

    /**
     * @param age
     *            the age to set
     */
    public void setAge(int age)
    {
        this.age = age;
    }

    /**
     * @param fieldToIgnore
     *            the fieldToIgnore to set
     */
    public void setFieldToIgnore(int fieldToIgnore)
    {
        this.fieldToIgnore = fieldToIgnore;
    }

    /**
     * @param name
     *            the name to set
     */
    public void setName(String name)
    {
        this.name = name;
    }

    /**
     * Modifier for the 'paramToTestCreationWithDefaultValue' attribute.
     *
     * @param paramToTestCreationWithDefaultValue
     *            the new paramToTestCreationWithDefaultValue value to set
     */
    public void setParamToTestCreationWithDefaultValue(Boolean paramToTestCreationWithDefaultValue)
    {
        this.paramToTestCreationWithDefaultValue = paramToTestCreationWithDefaultValue;
    }
}
