/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.utils.config.tests;

import java.util.Date;

import pt.digitalis.utils.config.annotations.ConfigID;
import pt.digitalis.utils.config.annotations.ConfigSectionIDGetter;
import pt.digitalis.utils.config.annotations.ConfigTestClass;

/**
 * Simple parcially annotated pojo class with a few attributes
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @created Sep 29, 2007
 */
@ConfigID("TestConfigurations")
@ConfigTestClass
public class ConfigsMockupSemiAnnotatedPojo {

    /** Address */
    private String address;

    /** Age */
    private int age;

    /** Age as a Double */
    private double ageDouble;

    /** Age as a Long */
    private long ageLong;

    /** Birth */
    private Date birthDate;

    /** Allows externally setting the getter of the section ID to fail on next call */
    public boolean forceFailSectionIDGetter = false;

    /** This is a test with an object that does not provide a String constructor. Will fail. */
    private ConfigsMockupPojo innerPojo;

    /** Fake attribute. Should be a boolean. The Config will pick this up as a convention violation in the tests */
    private String javaGuru;

    /** Is a javaProgrammer? */
    private boolean javaProgrammer;

    /** Name */
    private String name;

    /**
     * @return the address
     */
    public String getAddress()
    {
        return address;
    }

    /**
     * @return the age
     */
    public int getAge()
    {
        return age;
    }

    /**
     * @return the ageDouble
     */
    public double getAgeDouble()
    {
        return ageDouble;
    }

    /**
     * @return the ageLong
     */
    public long getAgeLong()
    {
        return ageLong;
    }

    /**
     * @return the birthDate
     */
    public Date getBirthDate()
    {
        return birthDate;
    }

    /**
     * @return the innerPojo
     */
    public ConfigsMockupPojo getInnerPojo()
    {
        return innerPojo;
    }

    /**
     * @return the javaGuru
     */
    public String getJavaGuru()
    {
        return javaGuru;
    }

    /**
     * Commented method so a setter not found is issued in the tests
     * 
     * @param address
     *            the address to set
     */
    // public void setAddress(String address) {
    // this.address = address;
    // }

    /**
     * @return the name
     */
    public String getName()
    {
        return name;
    }

    /**
     * @return the forceFailSectionIDGetter
     */
    public boolean isForceFailSectionIDGetter()
    {
        return forceFailSectionIDGetter;
    }

    /**
     * @return the javaGuru
     */
    public String isJavaGuru()
    {
        return javaGuru;
    }

    /**
     * @return the javaProgrammer
     */
    public boolean isJavaProgrammer()
    {
        return javaProgrammer;
    }

    /**
     * A dynamic Section ID method
     * 
     * @return the fake section IF
     * @throws Exception
     *             to test when an exception is thrown
     */
    @ConfigSectionIDGetter
    public String sectionID() throws Exception
    {
        if (forceFailSectionIDGetter)
            throw new Exception("Forced exception Just for testing purposes...");
        else
            return "SectionFakeID";
    }

    /**
     * @param address
     *            the address to set
     */
    public void setAddress(String address)
    {
        this.address = address;
    }

    /**
     * @param age
     *            the age to set
     */
    public void setAge(int age)
    {
        this.age = age;
    }

    /**
     * @param age
     *            the age to set
     * @param fail
     *            second parameter for testing purposes. Renders this setter unusable by ConfigUtils
     */
    public void setAge(int age, boolean fail)
    {
        this.age = age;
    }

    /**
     * @param ageDouble
     *            the ageDouble to set
     */
    public void setAgeDouble(double ageDouble)
    {
        this.ageDouble = ageDouble;
    }

    /**
     * @param ageLong
     *            the ageLong to set
     */
    public void setAgeLong(long ageLong)
    {
        this.ageLong = ageLong;
    }

    /**
     * @param birthDate
     *            the birthDate to set
     */
    public void setBirthDate(Date birthDate)
    {
        this.birthDate = birthDate;
    }

    /**
     * @param forceFailSectionIDGetter
     *            the forceFailSectionIDGetter to set
     */
    public void setForceFailSectionIDGetter(boolean forceFailSectionIDGetter)
    {
        this.forceFailSectionIDGetter = forceFailSectionIDGetter;
    }

    /**
     * @param innerPojo
     *            the innerPojo to set
     */
    public void setInnerPojo(ConfigsMockupPojo innerPojo)
    {
        this.innerPojo = innerPojo;
    }

    /**
     * @param javaGuru
     *            the javaGuru to set
     */
    public void setJavaGuru(String javaGuru)
    {
        this.javaGuru = javaGuru;
    }

    /**
     * @param javaProgrammer
     *            the javaProgrammer to set
     */
    public void setJavaProgrammer(boolean javaProgrammer)
    {
        this.javaProgrammer = javaProgrammer;
    }

    /**
     * @param name
     *            the name to set
     */
    public void setName(String name)
    {
        this.name = name;
    }
}
