/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.utils.config;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import pt.digitalis.log.Logger;
import pt.digitalis.utils.common.StringUtils;
import pt.digitalis.utils.config.AbstractConfigurationsImpl;
import pt.digitalis.utils.config.ConfigurationException;

public class ConfigurationsPreferencesImpl
extends AbstractConfigurationsImpl {
    private static boolean prefixedConfigurationsActive = false;
    private static Map<String, List<String>> prefixException = new HashMap<String, List<String>>();

    public ConfigurationsPreferencesImpl() throws ConfigurationException {
        this(true, false);
    }

    public ConfigurationsPreferencesImpl(boolean ignoreTestConfigurations) throws ConfigurationException {
        this(ignoreTestConfigurations, false);
    }

    public ConfigurationsPreferencesImpl(boolean ignoreTestConfigurations, boolean forcePrefixedConfigurationsActive) throws ConfigurationException {
        super(ignoreTestConfigurations);
        Properties props = this.readConfiguration("Configurations", "General", false);
        prefixedConfigurationsActive = Boolean.parseBoolean(props.getProperty("PrefixedConfigurationsActive", "false"));
        props.put("PrefixedConfigurationsActive", (Object)prefixedConfigurationsActive);
        this.writeConfiguration("Configurations", "General", props, false);
        props = this.readConfiguration("Configurations", "PrefixExceptions", false);
        for (Map.Entry<Object, Object> property : props.entrySet()) {
            if (property.getKey() == null || property.getValue() == null) continue;
            String prefix = property.getKey().toString();
            String[] exceptions = property.getValue().toString().split(",");
            prefixException.put(prefix, Arrays.asList(exceptions));
        }
        if (forcePrefixedConfigurationsActive) {
            prefixedConfigurationsActive = true;
        }
    }

    private String[] getChildrens(String configID, String sectionID) throws BackingStoreException {
        boolean usePrefix;
        if (sectionID != null && !"".equals(sectionID)) {
            configID = configID + "/" + sectionID;
        }
        if (usePrefix = this.isPrefixedConfiguration(configID)) {
            configID = this.getGeneralPrefix() + configID;
        }
        if (StringUtils.isNotBlank((String)configID) && !configID.startsWith("/")) {
            configID = "/" + configID;
        }
        if ("/".equals(configID)) {
            configID = "";
        }
        if (configID.endsWith("/")) {
            configID = configID.substring(0, configID.length() - 1);
        }
        Preferences systemPrefs = this.getPreferences(configID);
        return systemPrefs.childrenNames();
    }

    @Override
    public String getGeneralPrefix() {
        return super.getGeneralPrefix() + "/";
    }

    private Preferences getPreferences(String configID) {
        Preferences result = System.getProperty("os.name").equalsIgnoreCase("Mac OS X") ? Preferences.userRoot() : Preferences.systemRoot();
        if (StringUtils.isNotBlank((String)configID)) {
            String node = configID.replaceAll("_", "-");
            result = result.node(node);
        }
        return result;
    }

    @Override
    public void initialize(boolean upgradeModelManagers) {
    }

    @Override
    public boolean isPersistentRepositoryEmpty() {
        return false;
    }

    protected boolean isPrefixedConfiguration(String configPath) {
        if (!this.isPrefixedConfigurationsActive()) {
            return false;
        }
        List<String> exceptions = prefixException.get(generalConfigurationPrefix);
        if (exceptions == null) {
            return true;
        }
        for (String exceptionPath : exceptions) {
            if (!configPath.startsWith(exceptionPath)) continue;
            return false;
        }
        return true;
    }

    public boolean isPrefixedConfigurationsActive() {
        return prefixedConfigurationsActive;
    }

    @Override
    public Map<String, Properties> readAllConfigurations(String configID, String sectionID) throws ConfigurationException {
        HashMap<String, Properties> result = new HashMap<String, Properties>();
        boolean usePrefix = this.isPrefixedConfiguration(configID + (StringUtils.isNotBlank((String)sectionID) ? "/" + sectionID : ""));
        try {
            for (String name : this.getChildrens(configID, sectionID)) {
                if (StringUtils.isBlank((String)configID)) {
                    configID = sectionID;
                    sectionID = "";
                }
                result.put(name, this.readConfiguration(configID, name, usePrefix));
            }
        }
        catch (BackingStoreException e) {
            throw new ConfigurationException(e);
        }
        return result;
    }

    @Override
    public <T> Map<String, T> readAllConfigurations(String configID, String sectionID, Class<T> clazz) throws ConfigurationException {
        HashMap<String, T> result = new HashMap<String, T>();
        try {
            String basePath = StringUtils.isBlank((String)sectionID) ? "" : sectionID + "/";
            for (String name : this.getChildrens(configID, sectionID)) {
                result.put(name, this.readConfiguration(configID, basePath + name, clazz));
            }
        }
        catch (BackingStoreException e) {
            throw new ConfigurationException(e);
        }
        return result;
    }

    @Override
    public Properties readConfiguration(String configID, String sectionID) throws ConfigurationException {
        return this.readConfiguration(configID, sectionID, this.isPrefixedConfiguration(configID + "/" + sectionID));
    }

    private Properties readConfiguration(String configID, String sectionID, boolean usePrefix) throws ConfigurationException {
        if (StringUtils.isBlank((String)configID)) {
            configID = sectionID;
            sectionID = "";
        }
        if (usePrefix) {
            configID = this.getGeneralPrefix() + configID;
        }
        if (sectionID != null && !"".equals(sectionID)) {
            configID = configID + "/" + sectionID;
        }
        if (!configID.startsWith("/")) {
            configID = "/" + configID;
        }
        if (configID.startsWith("//")) {
            configID = configID.substring(1);
        }
        if (configID.endsWith("/")) {
            configID = configID.substring(0, configID.length() - 1);
        }
        Preferences systemPrefs = this.getPreferences(configID);
        Properties propObj = new Properties();
        try {
            systemPrefs.sync();
            StringBuffer out = new StringBuffer();
            for (String key : systemPrefs.keys()) {
                if (!StringUtils.isNotBlank((String)key) || systemPrefs.get(key, null) == null) continue;
                propObj.put(key, systemPrefs.get(key, null));
                if (key.toLowerCase().contains("password")) {
                    out.append("  " + key + "=[*******]\n");
                    continue;
                }
                out.append("  " + key + "=[" + propObj.getProperty(key) + "]\n");
            }
            if (out.length() > 0) {
                Logger.getLogger().debug((Object)("Configuration " + configID + ":\n" + out.toString()));
            }
            return propObj;
        }
        catch (BackingStoreException e) {
            throw new ConfigurationException(e);
        }
    }

    @Override
    public boolean removeConfiguration(String configID, String sectionID) throws ConfigurationException {
        return this.removeConfiguration(configID, sectionID, this.isPrefixedConfiguration(configID + "/" + sectionID));
    }

    public boolean removeConfiguration(String configID, String sectionID, boolean usePrefix) throws ConfigurationException {
        if (StringUtils.isBlank((String)configID)) {
            configID = sectionID;
            sectionID = "";
        }
        if (usePrefix) {
            configID = this.getGeneralPrefix() + configID;
        }
        if (sectionID != null && !"".equals(sectionID)) {
            configID = configID + "/" + sectionID;
        }
        if (!configID.startsWith("/")) {
            configID = "/" + configID;
        }
        try {
            Preferences systemPrefs = this.getPreferences(configID);
            systemPrefs.removeNode();
            systemPrefs.flush();
            return true;
        }
        catch (BackingStoreException e) {
            throw new ConfigurationException(e);
        }
    }

    @Override
    public boolean removeConfigurationParameter(String configID, String sectionID, String paramName) throws ConfigurationException {
        return this.removeConfigurationParameter(configID, sectionID, paramName, this.isPrefixedConfiguration(configID + "/" + sectionID));
    }

    public boolean removeConfigurationParameter(String configID, String sectionID, String paramName, boolean usePrefix) throws ConfigurationException {
        if (StringUtils.isBlank((String)configID)) {
            configID = sectionID;
            sectionID = "";
        }
        if (usePrefix) {
            configID = this.getGeneralPrefix() + configID;
        }
        if (sectionID != null && !"".equals(sectionID)) {
            configID = configID + "/" + sectionID;
        }
        if (!configID.startsWith("/")) {
            configID = "/" + configID;
        }
        try {
            Preferences systemPrefs = this.getPreferences(configID);
            systemPrefs.remove(paramName);
            systemPrefs.flush();
            return true;
        }
        catch (BackingStoreException e) {
            throw new ConfigurationException(e);
        }
    }

    @Override
    public boolean writeConfiguration(String configID, String sectionID, Properties values) throws ConfigurationException {
        return this.writeConfiguration(configID, sectionID, values, this.isPrefixedConfiguration(configID + "/" + sectionID));
    }

    public boolean writeConfiguration(String configID, String sectionID, Properties values, boolean usePrefix) throws ConfigurationException {
        if (StringUtils.isBlank((String)configID)) {
            configID = sectionID;
            sectionID = "";
        }
        if (usePrefix) {
            configID = this.getGeneralPrefix() + configID;
        }
        if (sectionID != null && !"".equals(sectionID)) {
            configID = configID + "/" + sectionID;
        }
        if (!configID.startsWith("/")) {
            configID = "/" + configID;
        }
        Preferences systemPrefs = this.getPreferences(configID);
        for (Map.Entry<Object, Object> entry : values.entrySet()) {
            if (entry.getValue() == null) continue;
            systemPrefs.put(entry.getKey().toString(), entry.getValue().toString());
        }
        try {
            systemPrefs.flush();
            return true;
        }
        catch (BackingStoreException e) {
            throw new ConfigurationException(e);
        }
    }
}

