/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.utils.config;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import pt.digitalis.log.Logger;
import pt.digitalis.utils.common.Chronometer;
import pt.digitalis.utils.common.CollectionUtils;
import pt.digitalis.utils.common.DateUtils;
import pt.digitalis.utils.common.StringUtils;
import pt.digitalis.utils.config.ConfigItem;
import pt.digitalis.utils.config.ConfigurationException;
import pt.digitalis.utils.config.IConfigurations;
import pt.digitalis.utils.config.annotations.ConfigAlias;
import pt.digitalis.utils.config.annotations.ConfigDefault;
import pt.digitalis.utils.config.annotations.ConfigID;
import pt.digitalis.utils.config.annotations.ConfigIgnore;
import pt.digitalis.utils.config.annotations.ConfigKeyID;
import pt.digitalis.utils.config.annotations.ConfigLOVAjaxEvent;
import pt.digitalis.utils.config.annotations.ConfigLOVValues;
import pt.digitalis.utils.config.annotations.ConfigPrivate;
import pt.digitalis.utils.config.annotations.ConfigSectionID;
import pt.digitalis.utils.config.annotations.ConfigSectionIDGetter;
import pt.digitalis.utils.config.annotations.ConfigTestClass;
import pt.digitalis.utils.config.annotations.ConfigVirtualPathForNode;
import pt.digitalis.utils.inspection.ReflectionUtils;
import pt.digitalis.utils.inspection.ResourceUtils;
import pt.digitalis.utils.inspection.exception.AuxiliaryOperationException;
import pt.digitalis.utils.inspection.exception.ResourceNotFoundException;

public abstract class AbstractConfigurationsImpl
implements IConfigurations {
    public static final String DEFAULT_VALUE_KEYWORK = "#DefaultValue#";
    public static String generalConfigurationPrefix = "";
    protected static Map<String, Class<?>> cachedConfigurations = null;
    protected static Map<String, Class<?>> cachedConfigurationsByVirtualPath = null;
    protected static List<String> cachedConfigurationsPackages = new ArrayList<String>();
    private boolean ignoreTestConfigurations;

    public AbstractConfigurationsImpl(boolean ignoreTestConfigurations) {
        this.ignoreTestConfigurations = ignoreTestConfigurations;
    }

    @Override
    public Map<String, Class<?>> getCacheConfigurationPoints() throws ConfigurationException {
        if (cachedConfigurations == null) {
            this.readAllConfigurationsPoints();
        }
        return cachedConfigurations;
    }

    @Override
    public Map<String, Class<?>> getCacheConfigurationPointsByVirtualPath() throws ConfigurationException {
        if (cachedConfigurationsByVirtualPath == null) {
            this.readAllConfigurationsPoints();
        }
        return cachedConfigurationsByVirtualPath;
    }

    public String getConfigID(Class<?> clazz) {
        ConfigID configAnnotation = clazz.getAnnotation(ConfigID.class);
        if (configAnnotation == null) {
            return null;
        }
        return configAnnotation.value();
    }

    @Override
    public List<ConfigItem> getConfigItemsMap(Class<?> clazz) {
        ArrayList<ConfigItem> configItems = new ArrayList<ConfigItem>();
        for (Method method : clazz.getMethods()) {
            if (method.getDeclaringClass() != clazz || !method.getName().startsWith("get") && !method.getName().startsWith("is") || method.isAnnotationPresent(ConfigIgnore.class)) continue;
            boolean booleanItem = method.getName().startsWith("is");
            boolean isPrivate = method.isAnnotationPresent(ConfigPrivate.class);
            Method getter = method;
            try {
                ConfigLOVAjaxEvent lovAjaxAnnotation;
                String key;
                Constructor<Object> constructor;
                Method setter = booleanItem ? ReflectionUtils.getMethod(clazz, (String)("set" + method.getName().substring(2))) : ReflectionUtils.getMethod(clazz, (String)("set" + method.getName().substring(3)));
                if (setter == null) {
                    throw new ResourceNotFoundException("Could not find setter method: set" + method.getName().substring(3) + " for " + clazz.getSimpleName());
                }
                if (setter.getParameterTypes().length != 1) {
                    Logger.getLogger().error((Object)("More than one parameter: method=" + setter.toGenericString()));
                    continue;
                }
                Class<Object> parameterClass = setter.getParameterTypes()[0];
                if (booleanItem && parameterClass != Boolean.TYPE && parameterClass != Boolean.class) {
                    Logger.getLogger().error((Object)("Prefix \"is\" for getter methods only allows for boolean attributes: method=" + setter.toGenericString()));
                    continue;
                }
                if (parameterClass == Integer.TYPE) {
                    parameterClass = Integer.class;
                } else if (parameterClass == Long.TYPE) {
                    parameterClass = Long.class;
                } else if (parameterClass == Double.TYPE) {
                    parameterClass = Double.class;
                } else if (parameterClass == Boolean.TYPE) {
                    parameterClass = Boolean.class;
                }
                try {
                    constructor = parameterClass.getConstructor(String.class);
                }
                catch (SecurityException e) {
                    constructor = null;
                }
                catch (NoSuchMethodException e) {
                    constructor = null;
                }
                if (constructor == null) {
                    System.err.println(method.getDeclaringClass() + "#" + method.getName());
                    Logger.getLogger().error((Object)("No constructor in the argument class for String value: method=" + setter.toGenericString()));
                    continue;
                }
                if (method.isAnnotationPresent(ConfigKeyID.class)) {
                    ConfigKeyID keyAnnotation = method.getAnnotation(ConfigKeyID.class);
                    key = keyAnnotation.value();
                } else {
                    String methodName = method.getName();
                    key = methodName.startsWith("is") ? method.getName().substring(2) : method.getName().substring(3);
                }
                ConfigDefault defaultValueAnnotation = method.getAnnotation(ConfigDefault.class);
                String defaultValue = defaultValueAnnotation == null ? null : defaultValueAnnotation.value();
                ConfigItem configItem = new ConfigItem(key, getter, setter, constructor, defaultValue, getter.getReturnType());
                configItem.setPrivate(isPrivate);
                ConfigAlias alias = method.getAnnotation(ConfigAlias.class);
                String name = alias != null && StringUtils.isNotBlank((String)alias.name()) ? alias.name() : StringUtils.camelCaseToString((String)key);
                String description = alias != null && StringUtils.isNotBlank((String)alias.name()) ? alias.description() : null;
                configItem.setName(name);
                configItem.setDescription(description);
                ConfigLOVValues lovValuesAnnotation = method.getAnnotation(ConfigLOVValues.class);
                if (lovValuesAnnotation != null && StringUtils.isNotBlank((String)lovValuesAnnotation.value())) {
                    configItem.setLovValues(CollectionUtils.keyValueStringToMap((String)lovValuesAnnotation.value()));
                }
                if ((lovAjaxAnnotation = method.getAnnotation(ConfigLOVAjaxEvent.class)) != null && StringUtils.isNotBlank((String)lovAjaxAnnotation.value())) {
                    configItem.setLovAjaxEvent(lovAjaxAnnotation.value());
                }
                configItems.add(configItem);
            }
            catch (ResourceNotFoundException e) {
                Logger.getLogger().error((Object)e.getMessage());
            }
        }
        return configItems;
    }

    private String getConfigPath(Class<?> clazz) {
        String configID = this.getConfigID(clazz);
        String configSectionID = this.getConfigSectionID(clazz);
        if (configID != null) {
            if (configSectionID == null) {
                return configID;
            }
            return configID + "/" + configSectionID;
        }
        return null;
    }

    public String getConfigSectionID(Class<?> clazz) {
        ConfigSectionID sectionAnnotation = clazz.getAnnotation(ConfigSectionID.class);
        if (sectionAnnotation == null) {
            return null;
        }
        return sectionAnnotation.value();
    }

    public String getConfigSectionID(Object obj) {
        ConfigSectionID sectionAnnotation = obj.getClass().getAnnotation(ConfigSectionID.class);
        if (sectionAnnotation == null) {
            ConfigSectionIDGetter sectionMethodAnnotation = null;
            Method sectionMethod = null;
            for (Method method : obj.getClass().getMethods()) {
                sectionMethodAnnotation = method.getAnnotation(ConfigSectionIDGetter.class);
                if (sectionMethodAnnotation == null) continue;
                sectionMethod = method;
                break;
            }
            if (sectionMethod == null) {
                return null;
            }
            try {
                return ReflectionUtils.invokeMethod(sectionMethod, (Object)obj, (Object[])new Object[0]).toString();
            }
            catch (Exception e) {
                Logger.getLogger().error((Object)e.getMessage());
                return null;
            }
        }
        return sectionAnnotation.value();
    }

    private String getConfigVirtualPath(Class<?> clazz) {
        ConfigVirtualPathForNode annotation = clazz.getAnnotation(ConfigVirtualPathForNode.class);
        if (annotation == null) {
            return this.getConfigPath(clazz);
        }
        return annotation.value();
    }

    @Override
    public String getGeneralPrefix() {
        return generalConfigurationPrefix;
    }

    public static void setGeneralPrefix(String configurationPrefix) {
        generalConfigurationPrefix = configurationPrefix;
    }

    @Override
    public String getRealPathForVirtualOne(String virtualPath) throws ConfigurationException {
        Class<?> clazz = this.getCacheConfigurationPointsByVirtualPath().get(virtualPath);
        if (clazz == null) {
            return null;
        }
        return this.getConfigPath(clazz);
    }

    protected boolean isTestConfigurationClass(Class<?> clazz) {
        ConfigTestClass testClassAnnotation = clazz.getAnnotation(ConfigTestClass.class);
        return testClassAnnotation != null;
    }

    protected boolean migrateFromOtherImplementation(IConfigurations oldConfigs, boolean stopIfNotEmpty) throws ConfigurationException {
        AbstractConfigurationsImpl newConfigs = this;
        Logger.getLogger().warn((Object)("Migrating Configurations repository " + oldConfigs.getClass().getSimpleName() + " => " + newConfigs.getClass().getSimpleName()));
        Chronometer crono = new Chronometer();
        crono.start();
        if (stopIfNotEmpty && !newConfigs.isPersistentRepositoryEmpty()) {
            Logger.getLogger().warn((Object)"Destination repository is not empty. Stoped migration process!");
            return false;
        }
        int migratedConfigs = 0;
        Logger.getLogger().warn((Object)"Parsing old configuration nodes...");
        Map<String, Properties> nodeNames = oldConfigs.readAllConfigurations("", "");
        Logger.getLogger().warn((Object)"Initiating migration...");
        for (Map.Entry<String, Properties> node : nodeNames.entrySet()) {
            migratedConfigs += this.migrateNodeTree("", node, oldConfigs);
        }
        crono.end();
        Logger.getLogger().warn((Object)("Migration complete! (" + migratedConfigs + " configuration nodes migrated in " + crono.getTimePassedAsFormattedString() + ")"));
        return true;
    }

    private int migrateNodeTree(String previousPath, Map.Entry<String, Properties> node, IConfigurations oldConfigs) throws ConfigurationException {
        AbstractConfigurationsImpl newConfigs = this;
        int migratedConfigs = 0;
        Properties nodeProps = oldConfigs.readConfiguration(previousPath, node.getKey());
        if (!nodeProps.isEmpty()) {
            Logger.getLogger().info((Object)("   - Node: " + (StringUtils.isNotBlank((String)previousPath) ? previousPath + "/" : "") + node.getKey()));
            newConfigs.writeConfiguration(previousPath, node.getKey(), nodeProps);
            ++migratedConfigs;
        }
        Map<String, Properties> children = StringUtils.isBlank((String)previousPath) ? oldConfigs.readAllConfigurations(node.getKey(), "") : oldConfigs.readAllConfigurations(previousPath, node.getKey());
        if (StringUtils.isNotBlank((String)previousPath)) {
            previousPath = previousPath + "/";
        }
        for (Map.Entry<String, Properties> childNode : children.entrySet()) {
            migratedConfigs += this.migrateNodeTree(previousPath + node.getKey(), childNode, oldConfigs);
        }
        return migratedConfigs;
    }

    @Override
    public void readAllConfigurationsPoints() throws ConfigurationException {
        cachedConfigurationsPackages.clear();
        cachedConfigurations = new HashMap();
        cachedConfigurationsByVirtualPath = new HashMap();
        ArrayList<String> basePackages = new ArrayList<String>();
        for (Package pck : Package.getPackages()) {
            String basePackage = pck.getName().split("\\.", 2)[0];
            if (basePackages.contains(basePackage)) continue;
            basePackages.add(basePackage);
        }
        for (String basePackage : basePackages) {
            this.readConfigurationsPointsForPackage(basePackage);
        }
    }

    @Override
    public <T> T readConfiguration(Class<T> clazz) throws ConfigurationException {
        if (clazz == null) {
            Logger.getLogger().error((Object)"The class cannot be null. Parse error!");
            return null;
        }
        String configID = this.getConfigID(clazz);
        String sectionID = this.getConfigSectionID(clazz);
        if (configID != null && sectionID != null) {
            return this.readConfiguration(configID, sectionID, clazz);
        }
        return null;
    }

    @Override
    public <T> T readConfiguration(String configID, String sectionID, Class<T> clazz) throws ConfigurationException {
        Object obj;
        boolean mustUpdate = false;
        if (clazz == null) {
            Logger.getLogger().error((Object)"The class cannot be null. Parse error!");
            return null;
        }
        Properties props = this.readConfiguration(configID, sectionID);
        try {
            obj = ReflectionUtils.instantiateObjectFromClass(clazz);
        }
        catch (AuxiliaryOperationException e) {
            Logger.getLogger().error((Object)("Could not create the Configuration Instance:\n" + e.getMessage()));
            return null;
        }
        List<ConfigItem> configItems = this.getConfigItemsMap(clazz);
        for (ConfigItem item : configItems) {
            String value = props == null ? null : props.getProperty(item.getKey());
            if ((props.isEmpty() || !props.containsKey(item.getKey())) && item.getDefaultValue() != null) {
                mustUpdate = true;
                value = item.getDefaultValue();
            }
            if (value != null && value.equalsIgnoreCase(DEFAULT_VALUE_KEYWORK)) {
                value = item.getDefaultValue();
            }
            if (StringUtils.isBlank((String)value)) continue;
            try {
                Object valueAsObject;
                if ("null".equals(value)) {
                    valueAsObject = null;
                } else if (item.getItemClass() == Date.class) {
                    valueAsObject = DateUtils.stringToDate((String)value);
                } else {
                    if (item.getItemClass() == Double.class) {
                        value = value.replace(',', '.');
                    }
                    valueAsObject = ReflectionUtils.instantiateObjectFromClass(item.getConstructor(), (Object[])new Object[]{value});
                }
                ReflectionUtils.invokeMethod((Method)item.getSetter(), (Object)obj, (Object[])new Object[]{valueAsObject});
            }
            catch (ParseException e) {
                Logger.getLogger().error((Object)("Could not convert to Date: \"" + value + "\"\n" + e.getMessage()));
                return null;
            }
            catch (AuxiliaryOperationException e) {
                Logger.getLogger().error((Object)("Could not call setter: " + item.getSetter().getName() + "\n" + e.getMessage()));
                return null;
            }
        }
        if (mustUpdate) {
            this.writeConfiguration(configID, sectionID, obj);
        }
        return (T)obj;
    }

    @Override
    public Map<String, String> readConfigurationAsMap(String configID, String sectionID) throws ConfigurationException {
        Properties properties = this.readConfiguration(configID, sectionID);
        HashMap<String, String> propObj = new HashMap<String, String>();
        for (Object object : properties.keySet()) {
            propObj.put(object.toString(), properties.getProperty(object.toString()));
        }
        return propObj;
    }

    @Override
    public Properties readConfigurationAsProperties(Class<?> clazz) throws ConfigurationException {
        if (clazz == null) {
            Logger.getLogger().error((Object)"The class cannot be null. Parse error!");
            return null;
        }
        String configID = this.getConfigID(clazz);
        String sectionID = this.getConfigSectionID(clazz);
        return this.readConfiguration(configID, sectionID);
    }

    @Override
    public Properties readConfigurationFromVirtualPath(String configVirtualPath) throws ConfigurationException {
        Class<?> clazz = cachedConfigurationsByVirtualPath.get(configVirtualPath);
        return this.readConfiguration(this.getConfigID(clazz), this.getConfigSectionID(clazz));
    }

    @Override
    public void readConfigurationsPointsForPackage(String basePackage) throws ConfigurationException {
        if (basePackage == null || "".equals(basePackage)) {
            this.readAllConfigurationsPoints();
        } else if (cachedConfigurations == null || cachedConfigurationsByVirtualPath == null) {
            cachedConfigurations = new HashMap();
            cachedConfigurationsByVirtualPath = new HashMap();
            cachedConfigurationsPackages.clear();
        }
        if (!cachedConfigurationsPackages.contains(basePackage)) {
            Logger.getLogger().debug((Object)("Reading configurations for package: \"" + basePackage + "\""));
            try {
                List classes = ResourceUtils.getClassesInDeepPackage((String)basePackage);
                for (String className : classes) {
                    try {
                        String configVirtualPath;
                        Class<?> clazz = Class.forName(className);
                        if (this.ignoreTestConfigurations && this.isTestConfigurationClass(clazz)) continue;
                        String configPath = this.getConfigPath(clazz);
                        if (configPath != null) {
                            cachedConfigurations.put(configPath, clazz);
                        }
                        if ((configVirtualPath = this.getConfigVirtualPath(clazz)) == null) continue;
                        cachedConfigurationsByVirtualPath.put(configVirtualPath, clazz);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            cachedConfigurationsPackages.add(basePackage);
        }
    }

    @Override
    public boolean removeConfiguration(Object bean) throws ConfigurationException {
        if (bean == null) {
            Logger.getLogger().error((Object)"The bean cannot be null. Parse error!");
            return false;
        }
        String configID = this.getConfigID(bean.getClass());
        String sectionID = this.getConfigSectionID(bean);
        if (configID != null && sectionID != null) {
            return this.removeConfiguration(configID, sectionID);
        }
        return false;
    }

    @Override
    public boolean writeConfiguration(Class<?> clazz, Properties values) throws ConfigurationException {
        if (clazz == null) {
            Logger.getLogger().error((Object)"The class cannot be null. Parse error!");
            return false;
        }
        String configID = this.getConfigID(clazz);
        String sectionID = this.getConfigSectionID(clazz);
        return this.writeConfiguration(configID, sectionID, values);
    }

    public boolean writeConfiguration(Object annotatedPojo) throws ConfigurationException {
        if (annotatedPojo == null) {
            Logger.getLogger().error((Object)"The pojo cannot be null. Parse error!");
            return false;
        }
        String configID = this.getConfigID(annotatedPojo.getClass());
        String sectionID = this.getConfigSectionID(annotatedPojo);
        if (configID != null && sectionID != null) {
            return this.writeConfiguration(configID, sectionID, annotatedPojo);
        }
        return false;
    }

    @Override
    public boolean writeConfiguration(String configID, String sectionID, Object bean) throws ConfigurationException {
        if (bean == null) {
            Logger.getLogger().error((Object)"The bean cannot be null. Parse error!");
            return false;
        }
        Properties props = new Properties();
        List<ConfigItem> configItems = this.getConfigItemsMap(bean.getClass());
        try {
            for (ConfigItem item : configItems) {
                Object value = ReflectionUtils.invokeMethod((Method)item.getGetter(), (Object)bean, (Object[])new Object[0]);
                String valueString = "";
                if (value != null) {
                    valueString = item.getItemClass() == Date.class ? DateUtils.dateToString((Date)((Date)value)) : value.toString();
                }
                if (valueString.equals(item.getDefaultValue())) {
                    valueString = DEFAULT_VALUE_KEYWORK;
                }
                props.setProperty(item.getKey(), valueString);
            }
        }
        catch (AuxiliaryOperationException e) {
            return false;
        }
        return this.writeConfiguration(configID, sectionID, props);
    }

    @Override
    public boolean writeConfigurationFromMap(String configID, String sectionID, Map<String, String> values) throws ConfigurationException {
        if (values == null) {
            Logger.getLogger().error((Object)"The values map cannot be null. Parse error!");
            return false;
        }
        Properties props = new Properties();
        for (Map.Entry<String, String> entrie : values.entrySet()) {
            props.put(entrie.getKey(), StringUtils.nvl((String)entrie.getValue(), (String)""));
        }
        return this.writeConfiguration(configID, sectionID, props);
    }
}

