package pt.digitalis.dif.content.model.dao.auto;

import java.util.Date;
import java.util.List;

import pt.digitalis.dif.content.model.data.Node;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;

/**
 * Home object for domain model class Node. Generated by ORM Generator DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.content.model.data.Node
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public interface IAutoNodeDAO extends IHibernateDAO<Node> {

    /**
     * Attach an unmodified Node instance in the persistence layer
     *
     * @param instance
     *            to attach
     */
    public void attachClean(Node instance);

    /**
     * Updates a modified Node in the persistence layer and reattaches them together
     *
     * @param instance
     *            to update/attach
     */
    public void attachDirty(Node instance);

    /**
     * Removes a Node instance from the persistence layer
     *
     * @param persistentInstance
     *            to remove/deletes
     */
    public void delete(Node persistentInstance);

    /**
     * Gets a {@link List} of all Node instances in the persistence layer
     *
     * @return the {@link List} of instances
     */
    public List<Node> findAll();

    /**
     * Gets a {@link List} of all Node instances in the persistence layer than match the creationDate attribute with the
     * given value
     *
     * @param creationDate
     *            to match
     * @return the {@link List} of instances
     */
    public List<Node> findByCreationDate(Date creationDate);

    /**
     * Gets a {@link List} of all Node instances in the persistence layer than match the creatorId attribute with the
     * given value
     *
     * @param creatorId
     *            to match
     * @return the {@link List} of instances
     */
    public List<Node> findByCreatorId(String creatorId);

    /**
     * Gets a {@link List} of all Node instances in the persistence layer than match the description attribute with the
     * given value
     *
     * @param description
     *            to match
     * @return the {@link List} of instances
     */
    public List<Node> findByDescription(String description);

    /**
     * Gets a {@link List} of all Node instances in the persistence layer than partially match the given field with the
     * given value
     *
     * @param field
     *            to match against
     * @param value
     *            to match
     * @return the {@link List} of instances
     */
    public List<Node> findByFieldParcial(Node.Fields field, String value);

    /**
     * Gets a {@link List} of all Node instances in the persistence layer than match the fullPath attribute with the
     * given value
     *
     * @param fullPath
     *            to match
     * @return the {@link List} of instances
     */
    public List<Node> findByFullPath(String fullPath);

    /**
     * Finds a Node instance in the persistence layer with the given id
     *
     * @param id
     *            to search
     * @return the found instance
     */
    public Node findById(java.lang.Long id);

    /**
     * Gets a {@link List} of all Node instances in the persistence layer than match the isPublic attribute with the
     * given value
     *
     * @param isPublic
     *            to match
     * @return the {@link List} of instances
     */
    public List<Node> findByIsPublic(Character isPublic);

    /**
     * Gets a {@link List} of all Node instances in the persistence layer than match the name attribute with the given
     * value
     *
     * @param name
     *            to match
     * @return the {@link List} of instances
     */
    public List<Node> findByName(String name);

    /**
     * Gets a {@link List} of all Node instances in the persistence layer than match the parentNodeId attribute with the
     * given value
     *
     * @param parentNodeId
     *            to match
     * @return the {@link List} of instances
     */
    public List<Node> findByParentNodeId(Long parentNodeId);

    /**
     * Obtains a new DataSet for the Node entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Node> getNodeDataSet();

    /**
     * Merge a Node instance back to the persistence layer updating it with the given instance data
     *
     * @param detachedInstance
     *            to update/merge
     * @return the merged instance
     */
    public Node merge(Node detachedInstance);

    /**
     * Persist a Node object to the persistence layer
     *
     * @param transientInstance
     *            to persist
     */
    public void persist(Node transientInstance);
}
