package pt.digitalis.dif.content.model.dao.auto.impl;

import static org.hibernate.criterion.Example.create;

import java.sql.Blob;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.MatchMode;

import pt.digitalis.dif.content.model.ContentManagerFactory;
import pt.digitalis.dif.content.model.dao.auto.IAutoContentItemDAO;
import pt.digitalis.dif.content.model.data.ContentItem;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.log.ILogWrapper;

/**
 * Home object for domain model class ContentItem. Generated by ORM Generator DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.content.model.data.ContentItem
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public abstract class AutoContentItemDAOImpl implements IAutoContentItemDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Constructor
     */
    public AutoContentItemDAOImpl()
    {
        this.logger = DIFLogger.getLogger();
    }

    /**
     * Attach an unmodified ContentItem instance in the persistence layer
     *
     * @param instance
     *            to attach
     */
    public void attachClean(ContentItem instance)
    {
        logger.debug("attaching clean ContentItem instance");
        getSession().lock(instance, LockMode.NONE);
        logger.debug("attach successful");
    }

    /**
     * Updates a modified ContentItem in the persistence layer and reattaches them together
     *
     * @param instance
     *            to update/attach
     */
    public void attachDirty(ContentItem instance)
    {
        logger.debug("attaching dirty ContentItem instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

    /**
     * Removes a ContentItem instance from the persistence layer
     *
     * @param persistentInstance
     *            to remove/deletes
     */
    public void delete(ContentItem persistentInstance)
    {
        logger.debug("deleting ContentItem instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

    /**
     * Gets a {@link List} of all ContentItem instances in the persistence layer
     *
     * @return the {@link List} of instances
     */
    @SuppressWarnings("unchecked")
    public List<ContentItem> findAll()
    {

        List<ContentItem> instances = new ArrayList<ContentItem>();
        logger.debug("getting all ContentItem instances");
        instances = getSession().createCriteria(ContentItem.class).list();
        if (instances.size() > 0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<ContentItem>) instances;
    }

    /**
     * Gets a {@link List} of all ContentItem instances in the persistence layer than match the content attribute with
     * the given value
     *
     * @param content
     *            to match
     * @return the {@link List} of instances
     */
    public List<ContentItem> findByContent(Blob content)
    {
        ContentItem instance = new ContentItem();

        instance.setContent(content);

        return findByExample(instance);
    }

    /**
     * Gets a {@link List} of all ContentItem instances in the persistence layer than match the creationDate attribute
     * with the given value
     *
     * @param creationDate
     *            to match
     * @return the {@link List} of instances
     */
    public List<ContentItem> findByCreationDate(Date creationDate)
    {
        ContentItem instance = new ContentItem();

        instance.setCreationDate(creationDate);

        return findByExample(instance);
    }

    /**
     * Gets a {@link List} of all ContentItem instances in the persistence layer than match the creatorId attribute with
     * the given value
     *
     * @param creatorId
     *            to match
     * @return the {@link List} of instances
     */
    public List<ContentItem> findByCreatorId(String creatorId)
    {
        ContentItem instance = new ContentItem();

        instance.setCreatorId(creatorId);

        return findByExample(instance);
    }

    /**
     * Gets a {@link List} of all ContentItem instances in the persistence layer than match the description attribute
     * with the given value
     *
     * @param description
     *            to match
     * @return the {@link List} of instances
     */
    public List<ContentItem> findByDescription(String description)
    {
        ContentItem instance = new ContentItem();

        instance.setDescription(description);

        return findByExample(instance);
    }

    /**
     * Gets a {@link List} of all ContentItem instances in the persistence layer than match the example of the given
     * instance
     *
     * @param instance
     *            to use as an example to the search
     * @return the {@link List} of instances
     */
    @SuppressWarnings("unchecked")
    protected List<ContentItem> findByExample(ContentItem instance)
    {
        logger.debug("finding ContentItem instance by example");
        List<ContentItem> results = (List<ContentItem>) getSession().createCriteria(ContentItem.class)
                .add(create(instance)).list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

    /**
     * Gets a {@link List} of all ContentItem instances in the persistence layer than partially match the given field
     * with the given value
     *
     * @param field
     *            to match against
     * @param value
     *            to match
     * @return the {@link List} of instances
     */
    @SuppressWarnings("unchecked")
    public List<ContentItem> findByFieldParcial(ContentItem.Fields field, String value)
    {
        logger.debug("finding ContentItem instance by parcial value: " + field + " like " + value);
        List<ContentItem> results = (List<ContentItem>) getSession().createCriteria(ContentItem.class)
                .add(Expression.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase()).list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }

    /**
     * Finds a ContentItem instance in the persistence layer with the given id
     *
     * @param id
     *            to search
     * @return the found instance
     */
    public ContentItem findById(java.lang.String id)
    {
        logger.debug("getting ContentItem instance with id: " + id);
        ContentItem instance = (ContentItem) getSession().get(ContentItem.class, id);
        if (instance == null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }

    /**
     * Gets a {@link List} of all ContentItem instances in the persistence layer than match the name attribute with the
     * given value
     *
     * @param name
     *            to match
     * @return the {@link List} of instances
     */
    public List<ContentItem> findByName(String name)
    {
        ContentItem instance = new ContentItem();

        instance.setName(name);

        return findByExample(instance);
    }

    /**
     * Obtains a new DataSet for the ContentItem entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<ContentItem> getContentItemDataSet()
    {
        return new HibernateDataSet<ContentItem>(ContentItem.class, this, ContentItem.getPKFieldListAsString());
    }

    /**
     * Retrieves the injected {@link Session} object
     *
     * @return the session
     */
    public Session getSession()
    {
        return ContentManagerFactory.getSession();
    }

    /**
     * Merge a ContentItem instance back to the persistence layer updating it with the given instance data
     *
     * @param detachedInstance
     *            to update/merge
     * @return the merged instance
     */
    public ContentItem merge(ContentItem detachedInstance)
    {
        logger.debug("merging ContentItem instance");
        ContentItem result = (ContentItem) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

    /**
     * Persist a ContentItem object to the persistence layer
     *
     * @param transientInstance
     *            to persist
     */
    public void persist(ContentItem transientInstance)
    {
        logger.debug("persisting ContentItem instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

}
