package pt.digitalis.dif.content.model.dao.auto;


import java.util.List;

import pt.digitalis.dif.content.model.data.NodeAcl;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.model.dataset.IDataSet;


/**
 * Home object for domain model class NodeAcl.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.content.model.data.NodeAcl
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public interface IAutoNodeAclDAO extends IHibernateDAO<NodeAcl> {

    /**
     * Obtains a new DataSet for the NodeAcl entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<NodeAcl> getNodeAclDataSet();

	/**
	 * Persist a NodeAcl object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(NodeAcl transientInstance);

	/**
	 * Updates a modified NodeAcl in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(NodeAcl instance);

	/**
	 * Attach an unmodified NodeAcl instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(NodeAcl instance);

	/**
	 * Removes a NodeAcl instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(NodeAcl persistentInstance);

	/**
	 * Merge a NodeAcl instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public NodeAcl merge(NodeAcl detachedInstance);

	/**
	 * Finds a NodeAcl instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public NodeAcl findById( java.lang.Long id);

	/**
	 * Gets a {@link List} of all NodeAcl instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    public List<NodeAcl> findAll();


	/**
	 * Gets a {@link List} of all NodeAcl instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    public List<NodeAcl> findByFieldParcial(NodeAcl.Fields field, String value);

	/**
	 * Gets a {@link List} of all NodeAcl instances
	 * in the persistence layer than match the userId attribute with the given value
	 *
	 * @param userId to match
	 * @return the {@link List} of instances
	 */
    public List<NodeAcl> findByUserId(String userId);

	/**
	 * Gets a {@link List} of all NodeAcl instances
	 * in the persistence layer than match the groupId attribute with the given value
	 *
	 * @param groupId to match
	 * @return the {@link List} of instances
	 */
    public List<NodeAcl> findByGroupId(String groupId);
}
