package pt.digitalis.dif.content.model.dao.auto.impl;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.content.model.ContentManagerFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.content.model.data.NodeAcl;
import pt.digitalis.dif.content.model.dao.auto.IAutoNodeAclDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class NodeAcl.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.content.model.data.NodeAcl
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public abstract class AutoNodeAclDAOImpl implements IAutoNodeAclDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the NodeAcl entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<NodeAcl> getNodeAclDataSet()
    {
        return new HibernateDataSet<NodeAcl>(NodeAcl.class, this, NodeAcl.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return ContentManagerFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public AutoNodeAclDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a NodeAcl object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(NodeAcl transientInstance) {
        logger.debug("persisting NodeAcl instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified NodeAcl in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(NodeAcl instance) {
        logger.debug("attaching dirty NodeAcl instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified NodeAcl instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(NodeAcl instance) {
        logger.debug("attaching clean NodeAcl instance");
        getSession().buildLockRequest(LockOptions.NONE).lock(instance);
        logger.debug("attach successful");
    }

	/**
	 * Removes a NodeAcl instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(NodeAcl persistentInstance) {
        logger.debug("deleting NodeAcl instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a NodeAcl instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public NodeAcl merge(NodeAcl detachedInstance) {
        logger.debug("merging NodeAcl instance");
        NodeAcl result = (NodeAcl) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a NodeAcl instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public NodeAcl findById( java.lang.Long id) {
        logger.debug("getting NodeAcl instance with id: " + id);
        NodeAcl instance = (NodeAcl) getSession()
                .get(NodeAcl.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all NodeAcl instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<NodeAcl> findAll() {

 		List<NodeAcl> instances = new ArrayList<NodeAcl>();
		logger.debug("getting all NodeAcl instances");
        instances = getSession().createCriteria(NodeAcl.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<NodeAcl>) instances;
    }


	/**
	 * Gets a {@link List} of all NodeAcl instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<NodeAcl> findByExample(NodeAcl instance) {
        logger.debug("finding NodeAcl instance by example");
        List<NodeAcl> results = (List<NodeAcl>) getSession()
                .createCriteria(NodeAcl.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all NodeAcl instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<NodeAcl> findByFieldParcial(NodeAcl.Fields field, String value) {
        logger.debug("finding NodeAcl instance by parcial value: "+field+" like "+value);
        List<NodeAcl> results = (List<NodeAcl>) getSession()
                .createCriteria(NodeAcl.class)
                .add( Restrictions.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }


	/**
	 * Gets a {@link List} of all NodeAcl instances
	 * in the persistence layer than match the userId attribute with the given value
	 *
	 * @param userId to match
	 * @return the {@link List} of instances
	 */
    public List<NodeAcl> findByUserId(String userId) {
        NodeAcl instance = new NodeAcl();

        instance.setUserId(userId);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all NodeAcl instances
	 * in the persistence layer than match the groupId attribute with the given value
	 *
	 * @param groupId to match
	 * @return the {@link List} of instances
	 */
    public List<NodeAcl> findByGroupId(String groupId) {
        NodeAcl instance = new NodeAcl();

        instance.setGroupId(groupId);

        return findByExample(instance);
    }

}

