package pt.digitalis.dif.content.model.dao.auto.impl;


import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.content.model.ContentManagerFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.content.model.data.Node;
import pt.digitalis.dif.content.model.dao.auto.IAutoNodeDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class Node.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.content.model.data.Node
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public abstract class AutoNodeDAOImpl implements IAutoNodeDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the Node entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Node> getNodeDataSet()
    {
        return new HibernateDataSet<Node>(Node.class, this, Node.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return ContentManagerFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public AutoNodeDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a Node object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(Node transientInstance) {
        logger.debug("persisting Node instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified Node in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(Node instance) {
        logger.debug("attaching dirty Node instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified Node instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(Node instance) {
        logger.debug("attaching clean Node instance");
        getSession().buildLockRequest(LockOptions.NONE).lock(instance);
        logger.debug("attach successful");
    }

	/**
	 * Removes a Node instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(Node persistentInstance) {
        logger.debug("deleting Node instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a Node instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public Node merge(Node detachedInstance) {
        logger.debug("merging Node instance");
        Node result = (Node) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a Node instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public Node findById( java.lang.Long id) {
        logger.debug("getting Node instance with id: " + id);
        Node instance = (Node) getSession()
                .get(Node.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all Node instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<Node> findAll() {

 		List<Node> instances = new ArrayList<Node>();
		logger.debug("getting all Node instances");
        instances = getSession().createCriteria(Node.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<Node>) instances;
    }


	/**
	 * Gets a {@link List} of all Node instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<Node> findByExample(Node instance) {
        logger.debug("finding Node instance by example");
        List<Node> results = (List<Node>) getSession()
                .createCriteria(Node.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all Node instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<Node> findByFieldParcial(Node.Fields field, String value) {
        logger.debug("finding Node instance by parcial value: "+field+" like "+value);
        List<Node> results = (List<Node>) getSession()
                .createCriteria(Node.class)
                .add( Restrictions.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }


	/**
	 * Gets a {@link List} of all Node instances
	 * in the persistence layer than match the name attribute with the given value
	 *
	 * @param name to match
	 * @return the {@link List} of instances
	 */
    public List<Node> findByName(String name) {
        Node instance = new Node();

        instance.setName(name);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Node instances
	 * in the persistence layer than match the description attribute with the given value
	 *
	 * @param description to match
	 * @return the {@link List} of instances
	 */
    public List<Node> findByDescription(String description) {
        Node instance = new Node();

        instance.setDescription(description);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Node instances
	 * in the persistence layer than match the creationDate attribute with the given value
	 *
	 * @param creationDate to match
	 * @return the {@link List} of instances
	 */
    public List<Node> findByCreationDate(Date creationDate) {
        Node instance = new Node();

        instance.setCreationDate(creationDate);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Node instances
	 * in the persistence layer than match the creatorId attribute with the given value
	 *
	 * @param creatorId to match
	 * @return the {@link List} of instances
	 */
    public List<Node> findByCreatorId(String creatorId) {
        Node instance = new Node();

        instance.setCreatorId(creatorId);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Node instances
	 * in the persistence layer than match the fullPath attribute with the given value
	 *
	 * @param fullPath to match
	 * @return the {@link List} of instances
	 */
    public List<Node> findByFullPath(String fullPath) {
        Node instance = new Node();

        instance.setFullPath(fullPath);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Node instances
	 * in the persistence layer than match the parentNodeId attribute with the given value
	 *
	 * @param parentNodeId to match
	 * @return the {@link List} of instances
	 */
    public List<Node> findByParentNodeId(Long parentNodeId) {
        Node instance = new Node();

        instance.setParentNodeId(parentNodeId);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Node instances
	 * in the persistence layer than match the isPublic attribute with the given value
	 *
	 * @param isPublic to match
	 * @return the {@link List} of instances
	 */
    public List<Node> findByIsPublic(Character isPublic) {
        Node instance = new Node();

        instance.setIsPublic(isPublic);

        return findByExample(instance);
    }

}

