/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.content.model.dao.auto.impl;

import java.io.Serializable;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.dif.content.model.ContentManagerFactory;
import pt.digitalis.dif.content.model.dao.auto.IAutoContentItemDAO;
import pt.digitalis.dif.content.model.data.ContentItem;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.log.ILogWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AutoContentItemDAOImpl
implements IAutoContentItemDAO {
    protected ILogWrapper logger = DIFLogger.getLogger();

    @Override
    public IDataSet<ContentItem> getContentItemDataSet() {
        return new HibernateDataSet(ContentItem.class, (IHibernateDAO)this, ContentItem.getPKFieldListAsString());
    }

    public Session getSession() {
        return ContentManagerFactory.getSession();
    }

    @Override
    public void persist(ContentItem transientInstance) {
        this.logger.debug((Object)"persisting ContentItem instance");
        this.getSession().persist((Object)transientInstance);
        this.logger.debug((Object)"persist successful");
    }

    @Override
    public void attachDirty(ContentItem instance) {
        this.logger.debug((Object)"attaching dirty ContentItem instance");
        this.getSession().saveOrUpdate((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void attachClean(ContentItem instance) {
        this.logger.debug((Object)"attaching clean ContentItem instance");
        this.getSession().buildLockRequest(LockOptions.NONE).lock((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void delete(ContentItem persistentInstance) {
        this.logger.debug((Object)"deleting ContentItem instance");
        this.getSession().delete((Object)persistentInstance);
        this.logger.debug((Object)"delete successful");
    }

    @Override
    public ContentItem merge(ContentItem detachedInstance) {
        this.logger.debug((Object)"merging ContentItem instance");
        ContentItem result = (ContentItem)this.getSession().merge((Object)detachedInstance);
        this.logger.debug((Object)"merge successful");
        return result;
    }

    @Override
    public ContentItem findById(String id) {
        this.logger.debug((Object)("getting ContentItem instance with id: " + id));
        ContentItem instance = (ContentItem)this.getSession().get(ContentItem.class, (Serializable)((Object)id));
        if (instance == null) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instance found");
        }
        return instance;
    }

    @Override
    public List<ContentItem> findAll() {
        List<ContentItem> instances = new ArrayList();
        this.logger.debug((Object)"getting all ContentItem instances");
        instances = this.getSession().createCriteria(ContentItem.class).list();
        if (instances.size() > 0) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instances found");
        }
        return instances;
    }

    protected List<ContentItem> findByExample(ContentItem instance) {
        this.logger.debug((Object)"finding ContentItem instance by example");
        List results = this.getSession().createCriteria(ContentItem.class).add((Criterion)Example.create((Object)instance)).list();
        this.logger.debug((Object)("find by example successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<ContentItem> findByFieldParcial(ContentItem.Fields field, String value) {
        this.logger.debug((Object)("finding ContentItem instance by parcial value: " + field + " like " + value));
        List results = this.getSession().createCriteria(ContentItem.class).add((Criterion)Restrictions.like((String)field.toString(), (String)value, (MatchMode)MatchMode.ANYWHERE).ignoreCase()).list();
        this.logger.debug((Object)("find by parcial value successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<ContentItem> findByName(String name) {
        ContentItem instance = new ContentItem();
        instance.setName(name);
        return this.findByExample(instance);
    }

    @Override
    public List<ContentItem> findByDescription(String description) {
        ContentItem instance = new ContentItem();
        instance.setDescription(description);
        return this.findByExample(instance);
    }

    @Override
    public List<ContentItem> findByCreationDate(Date creationDate) {
        ContentItem instance = new ContentItem();
        instance.setCreationDate(creationDate);
        return this.findByExample(instance);
    }

    @Override
    public List<ContentItem> findByCreatorId(String creatorId) {
        ContentItem instance = new ContentItem();
        instance.setCreatorId(creatorId);
        return this.findByExample(instance);
    }

    @Override
    public List<ContentItem> findByContent(Blob content) {
        ContentItem instance = new ContentItem();
        instance.setContent(content);
        return this.findByExample(instance);
    }
}

