/* ## CRIAO DA SEQUNCIA CMS.SEQ_ID_CONTENT_ITEM_ACL ## */
DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_SEQUENCES
  WHERE  SEQUENCE_OWNER = 'CMS'
  AND    SEQUENCE_NAME  = 'SEQ_ID_CONTENT_ITEM_ACL';

  IF TOTAL = 0 THEN
    SELECT NVL(MAX(ID), 0) + 1
    INTO   TOTAL
    FROM   CMS.CONTENT_ITEM_ACL;

    EXECUTE IMMEDIATE 'CREATE SEQUENCE CMS.SEQ_ID_CONTENT_ITEM_ACL START WITH '|| TO_CHAR(TOTAL) ||' INCREMENT BY 1 MINVALUE 1 MAXVALUE 999999999 NOCACHE CYCLE';
  END IF;
END;
/

CREATE OR REPLACE TRIGGER CMS.TRG_CONTENT_ITEM_ACL_BFR_INS
BEFORE INSERT ON CMS.CONTENT_ITEM_ACL
FOR EACH ROW
DECLARE
  NID NUMBER;
BEGIN
  IF :NEW.ID IS NULL THEN
    SELECT SEQ_ID_CONTENT_ITEM_ACL.NEXTVAL
    INTO   NID
    FROM   DUAL;

    :NEW.ID := NID;
  END IF;
END TRG_CONTENT_ITEM_ACL_BFR_INS;
/

/* ## CRIAO DA SEQUNCIA CMS.SEQ_ID_NODE ## */
DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_SEQUENCES
  WHERE  SEQUENCE_OWNER = 'CMS'
  AND    SEQUENCE_NAME  = 'SEQ_ID_NODE';

  IF TOTAL = 0 THEN
    SELECT NVL(MAX(ID), 0) + 1
    INTO   TOTAL
    FROM   CMS.NODE;

    EXECUTE IMMEDIATE 'CREATE SEQUENCE CMS.SEQ_ID_NODE START WITH '|| TO_CHAR(TOTAL) ||' INCREMENT BY 1 MINVALUE 1 MAXVALUE 999999999 NOCACHE CYCLE';
  END IF;
END;
/

CREATE OR REPLACE TRIGGER CMS.TRG_NODE_BFR_INS
BEFORE INSERT ON CMS.NODE
FOR EACH ROW
DECLARE
  NID NUMBER;
BEGIN
  IF :NEW.ID IS NULL THEN
    SELECT SEQ_ID_NODE.NEXTVAL
    INTO   NID
    FROM   DUAL;

    :NEW.ID := NID;
  END IF;
END TRG_NODE_BFR_INS;
/

/* ## CRIAO DA SEQUNCIA CMS.SEQ_ID_NODE_ACL ## */
DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_SEQUENCES
  WHERE  SEQUENCE_OWNER = 'CMS'
  AND    SEQUENCE_NAME  = 'SEQ_ID_NODE_ACL';

  IF TOTAL = 0 THEN
    SELECT NVL(MAX(ID), 0) + 1
    INTO   TOTAL
    FROM   CMS.NODE_ACL;

    EXECUTE IMMEDIATE 'CREATE SEQUENCE CMS.SEQ_ID_NODE_ACL START WITH '|| TO_CHAR(TOTAL) ||' INCREMENT BY 1 MINVALUE 1 MAXVALUE 999999999 NOCACHE CYCLE';
  END IF;
END;
/

CREATE OR REPLACE TRIGGER CMS.TRG_NODE_ACL_BFR_INS
BEFORE INSERT ON CMS.NODE_ACL
FOR EACH ROW
DECLARE
  NID NUMBER;
BEGIN
  IF :NEW.ID IS NULL THEN
    SELECT SEQ_ID_NODE_ACL.NEXTVAL
    INTO   NID
    FROM   DUAL;

    :NEW.ID := NID;
  END IF;
END TRG_NODE_ACL_BFR_INS;
/