package pt.digitalis.dif.content.model;

import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.utils.common.IBeanAttributes;
import pt.digitalis.dif.content.model.dao.auto.IContentItemDAO;
import pt.digitalis.dif.content.model.data.ContentItem;
import pt.digitalis.dif.content.model.dao.auto.IContentItemAclDAO;
import pt.digitalis.dif.content.model.data.ContentItemAcl;
import pt.digitalis.dif.content.model.dao.auto.INodeDAO;
import pt.digitalis.dif.content.model.data.Node;
import pt.digitalis.dif.content.model.dao.auto.INodeAclDAO;
import pt.digitalis.dif.content.model.data.NodeAcl;

/**
 * NOTE: This file is auto generated and will be overwrite in a future file generation.
 */
public interface IDocumentsService {

	/**
	 * Obtains a new ContentItem DAO
	 *
	 * @return A new IContentItemDAO
	 */
    public IContentItemDAO getContentItemDAO();

    /**
     * Obtains a new DataSet for the ContentItem entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<ContentItem> getContentItemDataSet();

	/**
	 * Obtains a new ContentItemAcl DAO
	 *
	 * @return A new IContentItemAclDAO
	 */
    public IContentItemAclDAO getContentItemAclDAO();

    /**
     * Obtains a new DataSet for the ContentItemAcl entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<ContentItemAcl> getContentItemAclDataSet();

	/**
	 * Obtains a new Node DAO
	 *
	 * @return A new INodeDAO
	 */
    public INodeDAO getNodeDAO();

    /**
     * Obtains a new DataSet for the Node entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Node> getNodeDataSet();

	/**
	 * Obtains a new NodeAcl DAO
	 *
	 * @return A new INodeAclDAO
	 */
    public INodeAclDAO getNodeAclDAO();

    /**
     * Obtains a new DataSet for the NodeAcl entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<NodeAcl> getNodeAclDataSet();


    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param clazz
     *            the entity class
     * @return A new IDataSet instance
     */
    public IDataSet<? extends IBeanAttributes> getDataSet(Class<? extends IBeanAttributes> clazz);

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param entityName
     *            the entity class simple name
     * @return A new IDataSet instance
     */
    public IDataSet<? extends IBeanAttributes> getDataSet(String entityName);
}