/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.content.model;

import org.hibernate.LobHelper;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;
import org.hibernate.context.ThreadLocalSessionContext;
import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.utils.TransactionExecuter;
import pt.digitalis.utils.common.IBeanAttributes;

public class ContentManagerFactory {
    public static String SESSION_FACTORY_NAME = "ContentManager";

    public static boolean executeTaskSameTransaction(TransactionExecuter executor, IBeanAttributes ... beans) {
        boolean success;
        block3: {
            success = false;
            boolean wasActive = ContentManagerFactory.openTransaction();
            try {
                executor.executeLogic(beans);
                if (!wasActive) {
                    ContentManagerFactory.getSession().getTransaction().commit();
                }
                success = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                if (wasActive) break block3;
                ContentManagerFactory.getSession().getTransaction().rollback();
            }
        }
        return success;
    }

    public static Configuration getConfiguration() {
        return HibernateUtil.getDatabaseConfiguration((String)SESSION_FACTORY_NAME, null);
    }

    public static LobHelper getLobHelper() {
        boolean wasActive = ContentManagerFactory.openTransaction();
        LobHelper result = ContentManagerFactory.getSession().getLobHelper();
        if (!wasActive) {
            ContentManagerFactory.getSession().getTransaction().commit();
        }
        return result;
    }

    public static org.hibernate.Session getSession() {
        SessionFactory sessionFactory = HibernateUtil.getSessionFactory((String)SESSION_FACTORY_NAME);
        Session session = sessionFactory.getCurrentSession();
        if (session != null && !session.isOpen()) {
            ThreadLocalSessionContext.unbind((SessionFactory)session.getSessionFactory());
            session = sessionFactory.getCurrentSession();
        }
        return session;
    }

    public static void setSessionFactoryName(String name) {
        SESSION_FACTORY_NAME = name;
    }

    public static boolean openTransaction() {
        boolean wasActive = ContentManagerFactory.getSession().getTransaction().isActive();
        if (!wasActive) {
            ContentManagerFactory.getSession().beginTransaction();
        }
        return wasActive;
    }
}

