/**
 * 2009, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.content;

import org.hibernate.cfg.Configuration;
import pt.digitalis.dif.content.model.ContentManagerFactory;
import pt.digitalis.dif.model.utils.AbstractModelManager;

/**
 * @author Luis Pinto <a href="mailto:lpinto@digitalis.pt">lpinto@digitalis.pt</a><br/>
 * @created Dec 19, 2013
 */
public class ContentManagerDBModelManager extends AbstractModelManager
{

    /** the model identifier */
    public static String MODEL_ID = "ContentManagerDBModelManager";

    /**
     * @see pt.digitalis.dif.model.utils.AbstractModelManager#getConfiguration()
     */
    @Override
    public Configuration getConfiguration()
    {
        return ContentManagerFactory.getConfiguration();
    }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractModelManager#getFactoryName()
     */
    @Override
    public String getFactoryName()
    {
        return ContentManagerFactory.SESSION_FACTORY_NAME;
    }

    /**
     * @see pt.digitalis.dif.controller.interfaces.IModelManager#getSchema()
     */
    public String getSchema()
    {
        return "CMS";
    }
}
