package pt.digitalis.dif.content.model.dao.auto.impl;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.content.model.ContentManagerFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.content.model.data.ContentItemAcl;
import pt.digitalis.dif.content.model.dao.auto.IContentItemAclDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class ContentItemAcl.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.content.model.data.ContentItemAcl
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public class ContentItemAclDAOImpl implements IContentItemAclDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the ContentItemAcl entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<ContentItemAcl> getContentItemAclDataSet()
    {
        return new HibernateDataSet<ContentItemAcl>(ContentItemAcl.class, this, ContentItemAcl.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return ContentManagerFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public ContentItemAclDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a ContentItemAcl object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(ContentItemAcl transientInstance) {
        logger.debug("persisting ContentItemAcl instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified ContentItemAcl in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(ContentItemAcl instance) {
        logger.debug("attaching dirty ContentItemAcl instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified ContentItemAcl instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(ContentItemAcl instance) {
        logger.debug("attaching clean ContentItemAcl instance");
        getSession().buildLockRequest(LockOptions.NONE).lock(instance);
        logger.debug("attach successful");
    }

	/**
	 * Removes a ContentItemAcl instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(ContentItemAcl persistentInstance) {
        logger.debug("deleting ContentItemAcl instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a ContentItemAcl instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public ContentItemAcl merge(ContentItemAcl detachedInstance) {
        logger.debug("merging ContentItemAcl instance");
        ContentItemAcl result = (ContentItemAcl) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a ContentItemAcl instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public ContentItemAcl findById( java.lang.Long id) {
        logger.debug("getting ContentItemAcl instance with id: " + id);
        ContentItemAcl instance = (ContentItemAcl) getSession()
                .get(ContentItemAcl.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all ContentItemAcl instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<ContentItemAcl> findAll() {

 		List<ContentItemAcl> instances = new ArrayList<ContentItemAcl>();
		logger.debug("getting all ContentItemAcl instances");
        instances = getSession().createCriteria(ContentItemAcl.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<ContentItemAcl>) instances;
    }


	/**
	 * Gets a {@link List} of all ContentItemAcl instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<ContentItemAcl> findByExample(ContentItemAcl instance) {
        logger.debug("finding ContentItemAcl instance by example");
        List<ContentItemAcl> results = (List<ContentItemAcl>) getSession()
                .createCriteria(ContentItemAcl.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all ContentItemAcl instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<ContentItemAcl> findByFieldParcial(ContentItemAcl.Fields field, String value) {
        logger.debug("finding ContentItemAcl instance by parcial value: "+field+" like "+value);
        List<ContentItemAcl> results = (List<ContentItemAcl>) getSession()
                .createCriteria(ContentItemAcl.class)
                .add( Restrictions.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }

}

