package pt.digitalis.dif.content.model.data;


import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.utils.common.DateUtils;

/**
 * Node
 * Generated on ORM Generator
 * DIF build process for the Model layer
 *
 */
@SuppressWarnings("serial")
public class Node extends AbstractBeanRelationsAttributes implements java.io.Serializable {

    /** Node attributes enumeration */
    public static class Fields {
        /** id column */
        public static final String ID = "id";
        /** name column */
        public static final String NAME = "name";
        /** description column */
        public static final String DESCRIPTION = "description";
        /** creationDate column */
        public static final String CREATIONDATE = "creationDate";
        /** creatorId column */
        public static final String CREATORID = "creatorId";
        /** fullPath column */
        public static final String FULLPATH = "fullPath";
        /** parentNodeId column */
        public static final String PARENTNODEID = "parentNodeId";
        /** isPublic column */
        public static final String ISPUBLIC = "isPublic";

	    /**
          * List of existing fields
	     *
	     * @return list of field names
	     */
        public static List<String> values() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("name");
            list.add("description");
            list.add("creationDate");
            list.add("creatorId");
            list.add("fullPath");
            list.add("parentNodeId");
            list.add("isPublic");

            return list;
        }
    }

	/**
 	 * The Class Relations.
 	 */
	 public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations {

        /**
         * Instantiates a new relations.
         *
         * @param currentPath
         *            the current path
         */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * nodeAcls relation.
         *
         * @return the nodeAcls bean relations attributes.
         */
        public NodeAcl.Relations nodeAcls()
        {
			NodeAcl c = new NodeAcl();
            return c.new Relations(this.buildPath("nodeAcls"));
        }
        
        /**
         * contentItems relation.
         *
         * @return the contentItems bean relations attributes.
         */
        public ContentItem.Relations contentItems()
        {
			ContentItem c = new ContentItem();
            return c.new Relations(this.buildPath("contentItems"));
        }
        
		/**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
		/**
         * the NAME path.
         *
         * @return the path
         */
        public String NAME()
        {
            return buildPath(Fields.NAME);
        }
		/**
         * the DESCRIPTION path.
         *
         * @return the path
         */
        public String DESCRIPTION()
        {
            return buildPath(Fields.DESCRIPTION);
        }
		/**
         * the CREATIONDATE path.
         *
         * @return the path
         */
        public String CREATIONDATE()
        {
            return buildPath(Fields.CREATIONDATE);
        }
		/**
         * the CREATORID path.
         *
         * @return the path
         */
        public String CREATORID()
        {
            return buildPath(Fields.CREATORID);
        }
		/**
         * the FULLPATH path.
         *
         * @return the path
         */
        public String FULLPATH()
        {
            return buildPath(Fields.FULLPATH);
        }
		/**
         * the PARENTNODEID path.
         *
         * @return the path
         */
        public String PARENTNODEID()
        {
            return buildPath(Fields.PARENTNODEID);
        }
		/**
         * the ISPUBLIC path.
         *
         * @return the path
         */
        public String ISPUBLIC()
        {
            return buildPath(Fields.ISPUBLIC);
        }
    }
	
	/** The dummy obj. */
    private static Node dummyObj = new Node();

	/**
     * Get Node Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
     */
    @Override
    protected Object getAttributeNoGraphNavigation(String attributeName) {

        if ("id".equalsIgnoreCase(attributeName))
            return id;
        if ("name".equalsIgnoreCase(attributeName))
            return name;
        if ("description".equalsIgnoreCase(attributeName))
            return description;
        if ("creationDate".equalsIgnoreCase(attributeName))
            return creationDate;
        if ("creatorId".equalsIgnoreCase(attributeName))
            return creatorId;
        if ("fullPath".equalsIgnoreCase(attributeName))
            return fullPath;
        if ("parentNodeId".equalsIgnoreCase(attributeName))
            return parentNodeId;
        if ("isPublic".equalsIgnoreCase(attributeName))
            return isPublic;
        if ("nodeAcls".equalsIgnoreCase(attributeName))
            return nodeAcls;
        if ("contentItems".equalsIgnoreCase(attributeName))
            return contentItems;

        return null;
    }

    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
     */
    @SuppressWarnings("all")
    public void setAttribute(String attributeName, Object attributeValue) {

        if ("id".equalsIgnoreCase(attributeName))
            id = (Long)attributeValue;
        if ("name".equalsIgnoreCase(attributeName))
            name = (String)attributeValue;
        if ("description".equalsIgnoreCase(attributeName))
            description = (String)attributeValue;
        if ("creationDate".equalsIgnoreCase(attributeName))
            creationDate = (Date)attributeValue;
        if ("creatorId".equalsIgnoreCase(attributeName))
            creatorId = (String)attributeValue;
        if ("fullPath".equalsIgnoreCase(attributeName))
            fullPath = (String)attributeValue;
        if ("parentNodeId".equalsIgnoreCase(attributeName))
            parentNodeId = (Long)attributeValue;
        if ("isPublic".equalsIgnoreCase(attributeName))
            isPublic = (Character)attributeValue;
        if ("nodeAcls".equalsIgnoreCase(attributeName))
            nodeAcls = (Set<NodeAcl>)attributeValue;
        if ("contentItems".equalsIgnoreCase(attributeName))
            contentItems = (Set<ContentItem>)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** name private attribute */
    private String name;

    /** description private attribute */
    private String description;

    /** creationDate private attribute */
    private Date creationDate;

    /** creatorId private attribute */
    private String creatorId;

    /** fullPath private attribute */
    private String fullPath;

    /** parentNodeId private attribute */
    private Long parentNodeId;

    /** isPublic private attribute */
    private Character isPublic;

    /** nodeAcls private attribute */
    private Set<NodeAcl> nodeAcls = new HashSet<NodeAcl>(0);

    /** contentItems private attribute */
    private Set<ContentItem> contentItems = new HashSet<ContentItem>(0);

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {

        Object value = getAttribute(attributeName);

        if (value == null)
            return "";
        else {
            if ("creationDate".equalsIgnoreCase(attributeName))
        	    return DateUtils.simpleDateToString((Date)value);
            return value.toString().trim();
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public Node() {
    }

	/** 
	 * minimal constructor
	 *
     * @param name
     * @param creationDate
     * @param creatorId
     * @param isPublic
    }
	 */
    public Node(String name, Date creationDate, String creatorId, Character isPublic) {
        this.name = name;
        this.creationDate = creationDate;
        this.creatorId = creatorId;
        this.isPublic = isPublic;
    }

    /**
     * full constructor
	 *
     * @param name
     * @param description
     * @param creationDate
     * @param creatorId
     * @param fullPath
     * @param parentNodeId
     * @param isPublic
     * @param nodeAcls
     * @param contentItems
     */
    public Node(String name, String description, Date creationDate, String creatorId, String fullPath, Long parentNodeId, Character isPublic, Set<NodeAcl> nodeAcls, Set<ContentItem> contentItems) {
        this.name = name;
        this.description = description;
        this.creationDate = creationDate;
        this.creatorId = creatorId;
        this.fullPath = fullPath;
        this.parentNodeId = parentNodeId;
        this.isPublic = isPublic;
        this.nodeAcls = nodeAcls;
        this.contentItems = contentItems;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id
     *
     * @return Node modified instance
     */
    public Node setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * name getter method
     *
     * @return name method
     */
    public String getName() {
        return this.name;
    }
    
    /**       
     * name setter method
     *
     * @param name
     *
     * @return Node modified instance
     */
    public Node setName(String name) {
        this.name = name;
        
        return this;
    }
    /**       
     * description getter method
     *
     * @return description method
     */
    public String getDescription() {
        return this.description;
    }
    
    /**       
     * description setter method
     *
     * @param description
     *
     * @return Node modified instance
     */
    public Node setDescription(String description) {
        this.description = description;
        
        return this;
    }
    /**       
     * creationDate getter method
     *
     * @return creationDate method
     */
    public Date getCreationDate() {
        return this.creationDate;
    }
    
    /**       
     * creationDate setter method
     *
     * @param creationDate
     *
     * @return Node modified instance
     */
    public Node setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
        
        return this;
    }
    /**       
     * creatorId getter method
     *
     * @return creatorId method
     */
    public String getCreatorId() {
        return this.creatorId;
    }
    
    /**       
     * creatorId setter method
     *
     * @param creatorId
     *
     * @return Node modified instance
     */
    public Node setCreatorId(String creatorId) {
        this.creatorId = creatorId;
        
        return this;
    }
    /**       
     * fullPath getter method
     *
     * @return fullPath method
     */
    public String getFullPath() {
        return this.fullPath;
    }
    
    /**       
     * fullPath setter method
     *
     * @param fullPath
     *
     * @return Node modified instance
     */
    public Node setFullPath(String fullPath) {
        this.fullPath = fullPath;
        
        return this;
    }
    /**       
     * parentNodeId getter method
     *
     * @return parentNodeId method
     */
    public Long getParentNodeId() {
        return this.parentNodeId;
    }
    
    /**       
     * parentNodeId setter method
     *
     * @param parentNodeId
     *
     * @return Node modified instance
     */
    public Node setParentNodeId(Long parentNodeId) {
        this.parentNodeId = parentNodeId;
        
        return this;
    }
    /**       
     * isPublic getter method
     *
     * @return isPublic method
     */
    public Character getIsPublic() {
        return this.isPublic;
    }
    
    /**       
     * isPublic setter method
     *
     * @param isPublic
     *
     * @return Node modified instance
     */
    public Node setIsPublic(Character isPublic) {
        this.isPublic = isPublic;
        
        return this;
    }
    /**       
     * nodeAcls getter method
     *
     * @return nodeAcls method
     */
    public Set<NodeAcl> getNodeAcls() {
        return this.nodeAcls;
    }
    
    /**       
     * nodeAcls setter method
     *
     * @param nodeAcls
     *
     * @return Node modified instance
     */
    public Node setNodeAcls(Set<NodeAcl> nodeAcls) {
        this.nodeAcls = nodeAcls;
        
        return this;
    }
    /**       
     * contentItems getter method
     *
     * @return contentItems method
     */
    public Set<ContentItem> getContentItems() {
        return this.contentItems;
    }
    
    /**       
     * contentItems setter method
     *
     * @param contentItems
     *
     * @return Node modified instance
     */
    public Node setContentItems(Set<ContentItem> contentItems) {
        this.contentItems = contentItems;
        
        return this;
    }

    /**
     * Creates a String representation of the Node object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("name").append("='").append(getName()).append("' ");			
        buffer.append("description").append("='").append(getDescription()).append("' ");			
        buffer.append("creationDate").append("='").append(getCreationDate()).append("' ");			
        buffer.append("creatorId").append("='").append(getCreatorId()).append("' ");			
        buffer.append("fullPath").append("='").append(getFullPath()).append("' ");			
        buffer.append("parentNodeId").append("='").append(getParentNodeId()).append("' ");			
        buffer.append("isPublic").append("='").append(getIsPublic()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the Node object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(Node other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("name".equalsIgnoreCase(attributeName))
        	this.name = attributeValue;

        if ("description".equalsIgnoreCase(attributeName))
        	this.description = attributeValue;

        if ("creationDate".equalsIgnoreCase(attributeName))
	        try {
        	    this.creationDate = DateUtils.stringToSimpleDate(attributeValue);
	        } catch (ParseException e) {
	            // Do nothing. The value will not be set!
	        }

        if ("creatorId".equalsIgnoreCase(attributeName))
        	this.creatorId = attributeValue;

        if ("fullPath".equalsIgnoreCase(attributeName))
        	this.fullPath = attributeValue;

        if ("parentNodeId".equalsIgnoreCase(attributeName))
            this.parentNodeId = Long.valueOf(attributeValue);

        if ("isPublic".equalsIgnoreCase(attributeName))
            if (attributeValue != null && attributeValue.length() > 0)
                this.isPublic = attributeValue.charAt(0);

    }


}
