/** 2007, Digitalis Informatica. All rights reserved.
 * 
 * Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1
 * 2780-666 Paco de Arcos
 * Telefone: (351) 21 4408990
 * Fax: (351) 21 4408999
 * http://www.digitalis.pt 
 */
package pt.digitalis.dif.controller.interfaces;

import pt.digitalis.dif.exception.controller.BusinessFlowException;
import pt.digitalis.dif.exception.controller.ControllerException;

/**
 * Defines an error handler for the Controller errors and resulting actions
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @created Dec 21, 2007
 */
public interface IDispatcherErrorHandler {

    /** The original request that caused the error attribute name */
    final static public String ORIGINAL_REQUEST = "Original Request";

    /** The exception that caused the error attribute name */
    final static public String EXCEPTION = "Exception";

    /**
     * Gets the default error response
     * 
     * @param originalrequest
     *            the request that generated the error
     * @param exception
     *            the exception that caused the error if available (null otherwise)
     * @return the default error response
     */
    public IDIFResponse getDefaultErrorResponse(IDIFRequest originalrequest, Exception exception);

    /**
     * Process an exception and determine the resulting action response
     * 
     * @param originalRequest
     *            the request that generated the error
     * @param businessFlowException
     * @return the calculated response to the given error
     */
    public IDIFResponse processException(IDIFRequest originalRequest, BusinessFlowException businessFlowException);

    /**
     * Process an exception and determine the resulting action response
     * 
     * @param originalRequest
     *            the request that generated the error
     * @param runtimeException
     * @return the calculated response to the given error
     */
    public IDIFResponse processException(IDIFRequest originalRequest, RuntimeException runtimeException);

    /**
     * Process an exception and determine the resulting action response
     * 
     * @param originalRequest
     *            the request that generated the error
     * @param controllerException
     * @return the calculated response to the given error
     */
    public IDIFResponse processException(IDIFRequest originalRequest, ControllerException controllerException);
}
