/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica.
 * Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos num.9 -
 * Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21
 * 4408999 http://www.digitalis.pt
 */
package pt.digitalis.dif.dem.annotations.security;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import pt.digitalis.dif.dem.annotations.metaannotations.BindToPrimary;

/**
 * This annotation defines a default ACL for the containing DEM entity. The annotation can be used on the following
 * elements: <code>@StageDefinition</code>.
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @created Dec 6, 2007
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@BindToPrimary( { "pt.digitalis.dif.dem.annotations.entities.StageDefinition" })
public @interface AccessControl {

    /** List of users that the current resource will be associated to in the ACLs */
    String users() default "";

    /** List of groups that the current resource will be associated to in the ACLs */
    String groups() default "";

    /**
     * If T the resource will be marked inaccessible to any user. This means that this resource can be granted but has
     * no grants by default. If F then it is a public resource.
     */
    boolean none() default false;
}
