/**
 * - Digitalis Internal Framework v2.0 -
 *
 * (C) 2007, Digitalis Informatica. 
 * 
 * Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1
 * 2780-666 Paco de Arcos
 * Telefone: (351) 21 4408990
 * Fax: (351) 21 4408999
 * http://www.digitalis.pt 
 */
package pt.digitalis.dif.dem.interfaces;

import java.util.Map;


/** This interface exposes behavior regarding Entity messages.
 * 
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @created 2007/05/03
 */
public interface IMessage {

    /** Returns all messages associated with the Entity.
     * 
     * @return a map with all the messages related to the Entity
     */
    public Map<String, String> getMessages();

    /** Returns a message associated with a given ID
     * 
     * @param messageID the message ID
     * @return the message with the given id
     */
    public String getMessage(String messageID);

}
