package pt.digitalis.dif.dem.managers.impl;

import java.util.HashMap;
import java.util.Map;

import pt.digitalis.dif.dem.DEMRegistryImpl;
import pt.digitalis.dif.dem.Entity;
import pt.digitalis.dif.dem.interfaces.IApplication;
import pt.digitalis.dif.dem.interfaces.IEntity;
import pt.digitalis.dif.dem.interfaces.IProvider;
import pt.digitalis.dif.dem.interfaces.IService;
import pt.digitalis.dif.dem.interfaces.IStage;
import pt.digitalis.dif.dem.managers.IDEMManager;

/**
 * This class manages the DEM entities, providing the connections between the elements to the CodeGen module. TODO: Do
 * performance tests to determine if the getters that search sequentially the Maps are too slow. One could keep an index
 * of IDs for each entity and gather by direct id searches the dependent entities we need. Since this will be seldom
 * used I think the effort is unnecessary.
 * 
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @created 2007/06/01
 */
public class DEMManagerImpl implements IDEMManager {

    // TODO: Try to see if one should cache the lists of entities so not to search all of them for ownership

    /**
     * @see pt.digitalis.dif.dem.managers.IDEMManager#getApplication(java.lang.String)
     */
    public IApplication getApplication(String applicationID)
    {
        return DEMRegistryImpl.getRegistry().getApplication(applicationID.toLowerCase());
    }

    /**
     * @see pt.digitalis.dif.dem.managers.IDEMManager#getApplications(pt.digitalis.dif.dem.interfaces.IProvider)
     */
    public Map<String, IApplication> getApplications(IProvider provider)
    {
        Map<String, IApplication> providerApplications = new HashMap<String, IApplication>();

        for (IApplication application: DEMRegistryImpl.getApplications().values())
        {
            // Prevent NPE in case an inexistent provider is referred
            if (application.getProvider() != null && application.getProvider().getID().equals(provider.getID()))
                providerApplications.put(application.getID(), application);
        }

        return providerApplications;
    }

    /**
     * @see pt.digitalis.dif.dem.managers.IDEMManager#getDefaultProvider()
     */
    public IProvider getDefaultProvider()
    {
        return DEMRegistryImpl.getDefaultProvider();
    }

    /**
     * @see pt.digitalis.dif.dem.managers.IDEMManager#getEntity(pt.digitalis.dif.dem.Entity, java.lang.String)
     */
    public IEntity getEntity(Entity type, String entityID)
    {
        if (Entity.PROVIDER.equals(type))
            return getProvider(entityID);

        else if (Entity.APPLICATION.equals(type))
            return getApplication(entityID);

        else if (Entity.SERVICE.equals(type))
            return getService(entityID);

        else if (Entity.STAGE.equals(type))
            return getStage(entityID);

        else
            return null;

        // if (Entity.PROVIDER.equals(type))
        // return getProvider(entityID);
        //
        // else if (Entity.APPLICATION.equals(type))
        // return getApplication(entityID);
        //
        // else if (Entity.SERVICE.equals(type))
        // return getService(entityID);
        //
        // else if (Entity.STAGE.equals(type))
        // return getStage(entityID);
        //
        // else
        // return null;
    }

    /**
     * @see pt.digitalis.dif.dem.managers.IDEMManager#getProvider(java.lang.String)
     */
    public IProvider getProvider(String providerID)
    {
        return DEMRegistryImpl.getRegistry().getProvider(providerID.toLowerCase());
    }

    /**
     * @see pt.digitalis.dif.dem.managers.IDEMManager#getProviders()
     */
    public Map<String, IProvider> getProviders()
    {
        return DEMRegistryImpl.getProviders();
    }

    /**
     * @see pt.digitalis.dif.dem.managers.IDEMManager#getService(java.lang.String)
     */
    public IService getService(String serviceID)
    {
        return DEMRegistryImpl.getRegistry().getService(serviceID.toLowerCase());
    }

    /**
     * @see pt.digitalis.dif.dem.managers.IDEMManager#getServices(pt.digitalis.dif.dem.interfaces.IApplication)
     */
    public Map<String, IService> getServices(IApplication application)
    {
        Map<String, IService> applicationServices = new HashMap<String, IService>();

        for (IService service: DEMRegistryImpl.getServices().values())
        {
            // Prevent NPE in case an inexistent application is referred
            if (service.getApplication() != null && service.getApplication().getID().equals(application.getID()))
                applicationServices.put(service.getID(), service);
        }

        return applicationServices;
    }

    /**
     * @see pt.digitalis.dif.dem.managers.IDEMManager#getStage(java.lang.String)
     */
    public IStage getStage(String stageID)
    {
        return DEMRegistryImpl.getRegistry().getStage(stageID.toLowerCase());
    }

    /**
     * @see pt.digitalis.dif.dem.managers.IDEMManager#getStages(pt.digitalis.dif.dem.interfaces.IService)
     */
    public Map<String, IStage> getStages(IService service)
    {
        Map<String, IStage> serviceStages = new HashMap<String, IStage>();

        for (IStage stage: DEMRegistryImpl.getStages().values())
        {
            // Prevent NPE in case an inexistent service is referred
            if (stage.getService() != null && stage.getService().getID().equals(service.getID()))
                serviceStages.put(stage.getID(), stage);
        }

        return serviceStages;
    }
}
