/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */
package pt.digitalis.dif.dem.objects.parameters;

import java.util.HashMap;
import java.util.Map;

import pt.digitalis.dif.exception.objects.ParameterException;

/**
 * A list of parameters
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @created Nov 22, 2007
 */
public class ParameterList {

    /** the parameters */
    @SuppressWarnings({"rawtypes"})
    private Map<String, IParameter> parameters = new HashMap<String, IParameter>();

    /**
     * Adds a parameter to the list
     * 
     * @param parameter
     *            the parameter to add
     */
    public void addParameter(IParameter<?> parameter)
    {
        parameters.put(parameter.getId(), parameter);
    }

    /**
     * Adds a parameter list to the current one
     * 
     * @param list
     *            the parameter list to add
     * @return the object with the new list added
     */
    public ParameterList addParameters(ParameterList list)
    {
        parameters.putAll(list.getParameters());

        return this;
    }

    /**
     * Creates a new instance of the current object
     * 
     * @return {@link ParameterList} clone
     * @throws CloneNotSupportedException
     */
    public ParameterList cloneMe() throws CloneNotSupportedException
    {
        ParameterList parameterListObj = new ParameterList();

        for (String key: parameters.keySet())
            parameterListObj.parameters.put(key, parameters.get(key).clone());

        return parameterListObj;
    }

    /**
     * Gets a parameter by it's id
     * 
     * @param id
     *            the id to search
     * @return the parameter
     */
    public IParameter<?> getParameter(String id)
    {
        if (id != null)
            id = id.toLowerCase();

        return parameters.get(id);
    }

    /**
     * Gets a parameter by it's id
     * 
     * @param <T>
     *            the type of the parameter
     * @param id
     *            the id to search
     * @param clazz
     *            the class of the parameter
     * @return the parameter
     */
    @SuppressWarnings("unchecked")
    public <T> IParameter<T> getParameter(String id, Class<T> clazz)
    {
        return parameters.get(id.toLowerCase());
    }

    /**
     * @return the parameters
     */
    @SuppressWarnings("rawtypes")
    public Map<String, IParameter> getParameters()
    {
        return parameters;
    }

    /**
     * Updates a parameter in the list. If it does not exist it is added to the list
     * 
     * @param parameter
     *            the parameter to update
     * @throws ParameterException
     *             if the parameter cannot be updated
     */
    @SuppressWarnings({"rawtypes", "unchecked"})
    public void updatesParameter(IParameter parameter) throws ParameterException
    {
        IParameter old = parameters.get(parameter.getId());

        if (old == null)
            addParameter(parameter);
        else
            old.setValue(parameter.getValue(null), null);
    }
}
