package pt.digitalis.dif.dem.objects.parameters.constraints.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import pt.digitalis.dif.dem.interfaces.IStageInstance;
import pt.digitalis.dif.dem.objects.parameters.constraints.AbstractParameterConstraint;

/**
 * @author Galaio da Silva <a href="mailto:jgalaio@digitalis.pt">jgalaio@digitalis.pt</a><br/>
 * @created Jul 27, 2010
 */
public class ParameterConstraintRegexImpl extends AbstractParameterConstraint {

    /** the separator for multiple regular expressions (Java & JavaScript) */
    public final static String REGEXP_COMMA = "<<COMMA>>";

    /** the end delimiter for multiple regular expressions (Java & JavaScript) */
    public final static String REGEXP_LIST_END = "<<END_REG_EXP>>";

    /** the separator for multiple regular expressions (Java & JavaScript) */
    public final static String REGEXP_LIST_SEPARATOR = "<<REG_EXP_SEP>>";

    /** the start delimiter for multiple regular expressions (Java & JavaScript) */
    public final static String REGEXP_LIST_START = "<<START_REG_EXP>>";

    /** Supported classes by numeric constraints */
    @SuppressWarnings("serial")
    final static private List<String> supportedClasses = new ArrayList<String>() {

        {
            add(String.class.getCanonicalName());
        }
    };

    /** Last tested value */
    String lastTestedValue;

    /** Regular Expression: Java syntax */
    String regexJava;

    /** Regular Expression: JavaScript syntax */
    String regexJavaScript;

    /**
     * @see pt.digitalis.dif.dem.objects.parameters.constraints.IParameterConstraint#configureConstraint(java.lang.String)
     */
    public void configureConstraint(String configurationString)
    {
        String value = configurationString.substring(configurationString.indexOf("=") + 1);

        if (value.contains(REGEXP_LIST_SEPARATOR))
        {
            String[] values = value.split(REGEXP_LIST_SEPARATOR);

            regexJava = values[0].substring(REGEXP_LIST_START.length());
            regexJavaScript = values[1].substring(0, values[1].length() - REGEXP_LIST_END.length());
        }
        else
        {
            regexJava = value;
            regexJavaScript = "/^" + value + "$/";
        }

        regexJava = regexJava.replaceAll(REGEXP_COMMA, ",");
        regexJavaScript = regexJavaScript.replaceAll(REGEXP_COMMA, ",");
    }

    /**
     * @see pt.digitalis.dif.dem.objects.parameters.constraints.AbstractParameterConstraint#getErrorMessageValues(boolean)
     */
    @Override
    protected Map<String, String> getErrorMessageValues(boolean parseValues)
    {
        Map<String, String> substitutions = new HashMap<String, String>();

        if (parseValues)
        {
            substitutions.put("value", lastTestedValue);
        }
        substitutions.put("regex", regexJava);

        return substitutions;
    }

    /**
     * @see pt.digitalis.dif.dem.objects.parameters.constraints.IParameterConstraint#getJavaScriptValidationCondition()
     */
    public String getJavaScriptValidationCondition()
    {
        return "(new RegExp(" + regexJavaScript + ").test(value))";
    }

    /**
     * @see pt.digitalis.dif.dem.objects.parameters.constraints.IParameterConstraint#isSupportedClass(java.lang.Class)
     */
    public boolean isSupportedClass(Class<?> clazz)
    {
        return supportedClasses.contains(clazz.getCanonicalName());
    }

    /**
     * @see pt.digitalis.dif.dem.objects.parameters.constraints.IParameterConstraint#validateConstraint(java.lang.String,
     *      pt.digitalis.dif.dem.interfaces.IStageInstance)
     */
    public boolean validateConstraint(String value, IStageInstance stageInstance)
    {
        lastTestedValue = value;

        return (value == null || value.matches(regexJava));
    }
}
