/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.ioc;

import pt.digitalis.dif.controller.security.managers.IAuthenticationManager;
import pt.digitalis.dif.controller.security.managers.IAuthorizationManager;
import pt.digitalis.dif.controller.security.managers.IIdentityManager;
import pt.digitalis.dif.controller.security.managers.impl.AuthenticationManagerStaticImpl;
import pt.digitalis.dif.controller.security.managers.impl.AuthorizationManagerStaticImpl;
import pt.digitalis.dif.controller.security.managers.impl.IdentityManagerStaticImpl;
import pt.digitalis.dif.controller.security.objects.DIFGroupImpl;
import pt.digitalis.dif.controller.security.objects.DIFUserImpl;
import pt.digitalis.dif.controller.security.objects.IDIFGroup;
import pt.digitalis.dif.controller.security.objects.IDIFUser;
import pt.digitalis.utils.ioc.modules.IIoCModule;
import pt.digitalis.utils.ioc.modules.IoCBinder;

/**
 * Contribution for parameter validation. Default constraints and validators
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @created Nov 16, 2007
 */
public class StaticSecurityModule implements IIoCModule {

    /**
     * @see pt.digitalis.utils.ioc.modules.IIoCModule#configure(pt.digitalis.utils.ioc.modules.IoCBinder)
     */
    public void configure(IoCBinder binder)
    {

        // Users & Groups
        binder.bind(IDIFUser.class, DIFUserImpl.class);
        binder.bind(IDIFGroup.class, DIFGroupImpl.class);

        // Authentication & Authorization
        binder.bind(IAuthenticationManager.class, AuthenticationManagerStaticImpl.class).withId("local").asSingleton();
        binder.bind(IAuthorizationManager.class, AuthorizationManagerStaticImpl.class).withId("static").asSingleton();
        binder.bind(IIdentityManager.class, IdentityManagerStaticImpl.class).withId("static").asSingleton();
    }
}
