package pt.digitalis.dif.sanitycheck;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import pt.digitalis.dif.sanitycheck.manager.SanityCheckTestSuiteDefinition;

/**
 * @author Galaio da Silva <a href="mailto:jgalaio@digitalis.pt">jgalaio@digitalis.pt</a><br/>
 * @created 1 de Jul de 2011
 */
public class SanityCheckResult {

    /** the test start time */
    private Date endTime;

    /** If a execution error occurs */
    private String executionError;

    /** Execution Result */
    private ExecutionResult executionsResult;

    /** the test start time */
    private Date startTime;

    /** List of test execution results */
    private List<TestResult> testResults = new ArrayList<TestResult>();

    /** the test suite definition */
    private SanityCheckTestSuiteDefinition testSuite;

    /**
     * @param testSuite
     * @param executionsResult
     */
    public SanityCheckResult(SanityCheckTestSuiteDefinition testSuite, ExecutionResult executionsResult)
    {
        super();
        this.testSuite = testSuite;
        this.executionsResult = executionsResult;
    }

    /**
     * Add a unit Sanity check result
     * 
     * @param result
     *            <code>SanityUnitResult</code>
     */
    public void addTestResult(TestResult result)
    {
        this.testResults.add(result);
    }

    /**
     * Inspector for the 'endTime' attribute.
     * 
     * @return the endTime value
     */
    public Date getEndTime()
    {
        return endTime;
    }

    /**
     * Inspector for the 'executionError' attribute.
     * 
     * @return the executionError value
     */
    public String getExecutionError()
    {
        return executionError;
    }

    /**
     * Inspector for the 'executionsResult' attribute.
     * 
     * @return the executionsResult value
     */
    public ExecutionResult getExecutionsResult()
    {
        return executionsResult;
    }

    /**
     * Inspector for the 'startTime' attribute.
     * 
     * @return the startTime value
     */
    public Date getStartTime()
    {
        return startTime;
    }

    /**
     * @return the milliseconds that the test execution took, or Null if it has not started/ended yet.
     */
    public Long getTestExecutionDuration()
    {
        if (getStartTime() == null || getEndTime() == null)
            return null;
        else
            return getEndTime().getTime() - getStartTime().getTime();
    }

    /**
     * Inspector for the 'results' attribute.
     * 
     * @return the results value
     */
    public List<TestResult> getTestResults()
    {
        return testResults;
    }

    /**
     * Inspector for the 'testSuite' attribute.
     * 
     * @return the testSuite value
     */
    public SanityCheckTestSuiteDefinition getTestSuite()
    {
        return testSuite;
    }

    /**
     * Modifier for the 'endTime' attribute.
     * 
     * @param endTime
     *            the new endTime value to set
     */
    public void setEndTime(Date endTime)
    {
        this.endTime = endTime;
    }

    /**
     * Modifier for the 'executionError' attribute.
     * 
     * @param executionError
     *            the new executionError value to set
     */
    public void setExecutionError(String executionError)
    {
        this.executionError = executionError;
    }

    /**
     * Modifier for the 'executionsResult' attribute.
     * 
     * @param executionsResult
     *            the new executionsResult value to set
     */
    public void setExecutionsResult(ExecutionResult executionsResult)
    {
        this.executionsResult = executionsResult;
    }

    /**
     * Modifier for the 'startTime' attribute.
     * 
     * @param startTime
     *            the new startTime value to set
     */
    public void setStartTime(Date startTime)
    {
        this.startTime = startTime;
    }
}
