package pt.digitalis.dif.utils.encryption;

import pt.digitalis.utils.crypto.IEncryptor;
import pt.digitalis.utils.crypto.impl.EncryptorBase64Impl;

/**
 * @author Galaio da Silva <a href="mailto:jgalaio@digitalis.pt">jgalaio@digitalis.pt</a><br/>
 * @created 3 de Out de 2011
 */
public class DIFEncryptator {

    /** Active Encriptator implementation */
    private static IEncryptor encryptator = null;

    /** The defined default Seed for DIF */
    private static final String SEED = "125DFsrSss7254Si";

    /**
     * Get the active encryptator instance
     * 
     * @return the encryptator instance
     */
    public static IEncryptor getEncryptator()
    {
        if (encryptator == null)
        {
            encryptator = new EncryptorBase64Impl();
            encryptator.setSeed(SEED);
        }
        return encryptator;
    }
}
