/**
 * 2009, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.utils.extensions.document;

import java.util.Arrays;
import java.util.Date;

/**
 * @author Galaio da Silva <a href="mailto:jgalaio@digitalis.pt">jgalaio@digitalis.pt</a><br/>
 * @created Jun 15, 2009
 */
public class DocumentRepositoryEntry {

    /**
     * Document Fields
     * 
     * @author Galaio da Silva <a href="mailto:jgalaio@digitalis.pt">jgalaio@digitalis.pt</a><br/>
     * @created Jun 15, 2009
     */
    public static enum Fields {
        /** The file in bytes */
        BYTE_CONTENT {

            @Override
            public String toString()
            {
                return "ByteContent";
            }
        },
        /** Creation Date */
        CREATION_DATE {

            @Override
            public String toString()
            {
                return "Date";
            }
        },
        /** The creator id */
        CREATOR {

            @Override
            public String toString()
            {
                return "Creator";
            }
        },
        /** Document Description */
        DESCRIPTION {

            @Override
            public String toString()
            {
                return "Description";
            }
        },
        /** Original file name */
        FILENAME {

            @Override
            public String toString()
            {
                return "FileName";
            }
        },
        /** Document Id */
        ID {

            @Override
            public String toString()
            {
                return "Id";
            }
        },

        /** The file myme type */
        MIMETYPE {

            @Override
            public String toString()
            {
                return "MimeType";
            }
        },
        /** Document Name */
        NAME {

            @Override
            public String toString()
            {
                return "Name";
            }
        }
    }

    /** the binary mimeType */
    private static final String BINARY_MIME_TYPE = "binary";

    /** The document data */
    private byte[] bytes;

    /** The date when the document was created */
    private Date creationDate;

    /** the creator user ID */
    private String creatorID;

    /**
     * For updates interfaces, indicating that the form through an FileUploadField/ImageUploadField has issued a delete
     * action on this document/"associated parameter"
     */
    private boolean deleteRequested;

    /** The document description */
    private String description;

    /** The original file name */
    private String fileName;

    /** the document unique identifier in the document repository */
    private Long id;

    /** The document mime Type */
    private String mimeType;

    /** The document name */
    private String name;

    /**
     * Default constructor for <code>DocumentRepositoryEntry</code>.
     */
    public DocumentRepositoryEntry()
    {
        super();

        creationDate = new Date();
    }

    /**
     * Constructor for <code>DocumentRepositoryEntry</code>.
     * 
     * @param id
     *            the document id.
     * @param creatorID
     *            the creator id.
     * @param name
     *            the document name.
     * @param description
     *            the document description.
     * @param fileName
     *            the document original fileName.
     * @param creationDate
     *            the Document creation date.
     * @param mimeType
     *            the document mimeType.
     * @param bytes
     *            the document content in bytes.
     */
    public DocumentRepositoryEntry(Long id, String creatorID, String name, String description, String fileName,
            Date creationDate, String mimeType, byte[] bytes)
    {
        this.id = id;
        this.creatorID = creatorID;
        this.name = name;
        this.description = description;
        this.fileName = fileName;
        this.creationDate = creationDate;
        this.mimeType = mimeType;
        this.bytes = bytes;
    }

    /**
     * Constructor for <code>DocumentRepositoryEntry</code>.
     * 
     * @param creatorID
     *            the creator id.
     * @param name
     *            the document name.
     * @param description
     *            the document description.
     * @param fileName
     *            the document original fileName.
     * @param creationDate
     *            the Document creation date.
     * @param mimeType
     *            the document mimeType.
     * @param bytes
     *            the document content in bytes.
     */
    public DocumentRepositoryEntry(String creatorID, String name, String description, String fileName,
            Date creationDate, String mimeType, byte[] bytes)
    {
        this.creatorID = creatorID;
        this.name = name;
        this.description = description;
        this.fileName = fileName;
        this.creationDate = creationDate;
        this.mimeType = mimeType;
        this.bytes = bytes;
    }

    /**
     * Automaticaly calculate the Mime Type
     */
    public void calculateMimeType()
    {
        if (this.fileName != null)
        {
            String[] splitFile = this.fileName.split("\\.");
            if (splitFile.length >= 2)
            {
                this.mimeType = splitFile[splitFile.length - 1];

            }
            else
            {
                this.mimeType = BINARY_MIME_TYPE;
            }
        }
    }

    /**
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object obj)
    {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (!(obj instanceof DocumentRepositoryEntry))
            return false;
        final DocumentRepositoryEntry other = (DocumentRepositoryEntry) obj;
        if (!Arrays.equals(bytes, other.bytes))
            return false;
        if (creationDate == null)
        {
            if (other.creationDate != null)
                return false;
        }
        else if (!creationDate.equals(other.creationDate))
            return false;
        if (creatorID == null)
        {
            if (other.creatorID != null)
                return false;
        }
        else if (!creatorID.equals(other.creatorID))
            return false;
        if (description == null)
        {
            if (other.description != null)
                return false;
        }
        else if (!description.equals(other.description))
            return false;
        if (fileName == null)
        {
            if (other.fileName != null)
                return false;
        }
        else if (!fileName.equals(other.fileName))
            return false;
        if (id == null)
        {
            if (other.id != null)
                return false;
        }
        else if (!id.equals(other.id))
            return false;
        if (mimeType == null)
        {
            if (other.mimeType != null)
                return false;
        }
        else if (!mimeType.equals(other.mimeType))
            return false;
        if (name == null)
        {
            if (other.name != null)
                return false;
        }
        else if (!name.equals(other.name))
            return false;
        return true;
    }

    /**
     * Inspector for the 'bytes' attribute.
     * 
     * @return the bytes value
     */
    public byte[] getBytes()
    {
        return bytes;
    }

    /**
     * Inspector for the 'creationDate' attribute.
     * 
     * @return the creationDate value
     */
    public Date getCreationDate()
    {
        return creationDate;
    }

    /**
     * Inspector for the 'creatorID' attribute.
     * 
     * @return the creatorID value
     */
    public String getCreatorID()
    {
        return creatorID;
    }

    /**
     * Inspector for the 'description' attribute.
     * 
     * @return the description value
     */
    public String getDescription()
    {
        return description;
    }

    /**
     * Inspector for the 'fileName' attribute.
     * 
     * @return the fileName value
     */
    public String getFileName()
    {
        return fileName;
    }

    /**
     * Inspector for the 'id' attribute.
     * 
     * @return the id value
     */
    public Long getId()
    {
        return id;
    }

    /**
     * Inspector for the 'mimeType' attribute.
     * 
     * @return the mimeType value
     */
    public String getMimeType()
    {
        return mimeType;
    }

    /**
     * Inspector for the 'name' attribute.
     * 
     * @return the name value
     */
    public String getName()
    {
        return name;
    }

    /**
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode()
    {
        final int prime = 31;
        int result = 1;
        result = prime * result + Arrays.hashCode(bytes);
        result = prime * result + ((creationDate == null) ? 0 : creationDate.hashCode());
        result = prime * result + ((creatorID == null) ? 0 : creatorID.hashCode());
        result = prime * result + ((description == null) ? 0 : description.hashCode());
        result = prime * result + ((fileName == null) ? 0 : fileName.hashCode());
        result = prime * result + ((id == null) ? 0 : id.hashCode());
        result = prime * result + ((mimeType == null) ? 0 : mimeType.hashCode());
        result = prime * result + ((name == null) ? 0 : name.hashCode());
        return result;
    }

    /**
     * Inspector for the 'deleteRequested' attribute.
     * 
     * @return the deleteRequested value
     */
    public boolean isDeleteRequested()
    {
        return deleteRequested;
    }

    /**
     * Modifier for the 'bytes' attribute.
     * 
     * @param bytes
     *            the new bytes value to set
     */
    public void setBytes(byte[] bytes)
    {
        this.bytes = bytes;
    }

    /**
     * Modifier for the 'creationDate' attribute.
     * 
     * @param creationDate
     *            the new creationDate value to set
     */
    public void setCreationDate(Date creationDate)
    {
        this.creationDate = creationDate;
    }

    /**
     * Modifier for the 'creatorID' attribute.
     * 
     * @param creatorID
     *            the new creatorID value to set
     */
    public void setCreatorID(String creatorID)
    {
        this.creatorID = creatorID;
    }

    /**
     * Modifier for the 'deleteRequested' attribute.
     * 
     * @param deleteRequested
     *            the new deleteRequested value to set
     */
    public void setDeleteRequested(boolean deleteRequested)
    {
        this.deleteRequested = deleteRequested;
    }

    /**
     * Modifier for the 'description' attribute.
     * 
     * @param description
     *            the new description value to set
     */
    public void setDescription(String description)
    {
        this.description = description;
    }

    /**
     * Modifier for the 'fileName' attribute.
     * 
     * @param fileName
     *            the new fileName value to set
     */
    public void setFileName(String fileName)
    {
        this.fileName = fileName;
    }

    /**
     * Modifier for the 'id' attribute.
     * 
     * @param id
     *            the new id value to set
     */
    public void setId(Long id)
    {
        this.id = id;
    }

    /**
     * Modifier for the 'mimeType' attribute.
     * 
     * @param mimeType
     *            the new mimeType value to set
     */
    public void setMimeType(String mimeType)
    {
        this.mimeType = mimeType;
    }

    /**
     * Modifier for the 'name' attribute.
     * 
     * @param name
     *            the new name value to set
     */
    public void setName(String name)
    {
        this.name = name;
    }

}
