/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.utils.logging;

import javax.servlet.ServletException;

import pt.digitalis.dif.startup.DIFStartupConfiguration;
import pt.digitalis.log.ILogWrapper;
import pt.digitalis.log.Logger;
import pt.digitalis.utils.common.StringUtils;
import pt.digitalis.utils.common.SystemUtils;

/**
 * Logger proxy for DiF.
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @author Rodrigo Gon�alves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @created Sep 24, 2007
 */
public class DIFLogger {

    /** The log. */
    private static ILogWrapper log = null;

    /**
     * Gets the logger object.
     * 
     * @return the logger
     */
    static public ILogWrapper getLogger()
    {
        /* Reset the log if the level has changed */
        if (log == null)
        {
            // Force the default logger to the desired log level
            Logger.getLogger().setLevel(DIFStartupConfiguration.getLogLevel());

            log = Logger.getLogger("DIF", DIFStartupConfiguration.getLogLevel());
        }
        else if (log != null && !log.getLevel().equals(DIFStartupConfiguration.getLogLevel()))
        {
            // Force the default logger to the desired log level
            Logger.getLogger().setLevel(DIFStartupConfiguration.getLogLevel(), true);

            log = Logger.getLogger("DIF", DIFStartupConfiguration.getLogLevel());
        }

        return log;
    }

    /**
     * Gets the stack trace.
     *
     * @param exception
     *            the exception
     * @return the stack trace
     */
    public static StringBuffer getStackTrace(Exception exception)
    {
        return getStackTrace(exception, "");
    }

    /**
     * Gets the stack trace.
     *
     * @param exception
     *            the exception
     * @param lineFeedChar
     *            the line feed char
     * @return the stack trace
     */
    public static StringBuffer getStackTrace(Exception exception, String lineFeedChar)
    {
        StringBuffer buffer = new StringBuffer();

        buffer.append(StringUtils.getFirstLine(exception.toString()));
        buffer.append(lineFeedChar + lineFeedChar);

        buffer.append(SystemUtils.getStackTraceListHTML(exception.getStackTrace()));

        Throwable innerException = exception.getCause();

        if (innerException == null)
            // If not cause and it's a ServletException use the rootClause instead...
            if (exception instanceof ServletException)
                innerException = ((ServletException) exception).getRootCause();

        while (innerException != null)
        {
            buffer.append(StringUtils.getFirstLine(innerException.toString()));
            buffer.append(lineFeedChar);

            buffer.append(SystemUtils.getStackTraceListHTML(innerException.getStackTrace()));

            if (innerException.getCause() == null)
            {
                // Has no cause
                if (innerException instanceof ServletException)
                    // If it's a ServletException use the rootClause instead...
                    innerException = ((ServletException) innerException).getRootCause();
                else
                    // else... end trace.
                    innerException = null;

            }
            else
                innerException = innerException.getCause();
        }

        return buffer;
    }

}
