/**
 * 2009, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.utils.logging;

import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.utils.config.IConfigurations;
import pt.digitalis.utils.config.annotations.ConfigDefault;
import pt.digitalis.utils.config.annotations.ConfigID;
import pt.digitalis.utils.config.annotations.ConfigIgnore;
import pt.digitalis.utils.config.annotations.ConfigSectionID;

/**
 * Configuration point for the Presentation layer
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created Sep 24, 2009
 */
@ConfigID("dif2")
@ConfigSectionID("Logging")
public class LoggingConfiguration {

    /** The singleton instance */
    static private LoggingConfiguration instance = null;

    /**
     * Returns the active configuration object instance.
     * 
     * @return the configuration instance
     */
    @ConfigIgnore
    static public LoggingConfiguration getInstance()
    {
        if (instance == null)
            try
            {
                instance = DIFIoCRegistry.getRegistry().getImplementation(IConfigurations.class)
                        .readConfiguration(LoggingConfiguration.class);
            }
            catch (Exception e)
            {
                instance = null;
            }

        return instance;
    }

    /** If T activate debugging in the model. */
    private Boolean debugModel;

    /** The Error Log Email Address */
    private String errorLogEmailAddress;

    /** The error Log Email Body */
    private String errorLogEmailBody;

    /** The error Log Email Subject */
    private String errorLogEmailSubject;

    /**
     * Inspector for the 'debugModel' attribute.
     * 
     * @return the debugModel value
     */
    @ConfigDefault("false")
    public Boolean getDebugModel()
    {
        return debugModel;
    }

    /**
     * Inspector for the 'errorLogEmailAddress' attribute.
     * 
     * @return the errorLogEmailAddress value
     */
    @ConfigDefault("")
    public String getErrorLogEmailAddress()
    {
        return errorLogEmailAddress;
    }

    /**
     * Inspector for the 'errorLogEmailBody' attribute.
     * 
     * @return the errorLogEmailBody value
     */
    @ConfigDefault("An error occurred in application ${applicationName}. You can see the details authentication as administrator and see \"Error Log Viewer\" service.")
    public String getErrorLogEmailBody()
    {
        return errorLogEmailBody;
    }

    /**
     * Inspector for the 'errorLogEmailSubject' attribute.
     * 
     * @return the errorLogEmailSubject value
     */
    @ConfigDefault("Error Log service")
    public String getErrorLogEmailSubject()
    {
        return errorLogEmailSubject;
    }

    /**
     * Modifier for the 'debugModel' attribute.
     * 
     * @param debugModel
     *            the new debugModel value to set
     */
    public void setDebugModel(Boolean debugModel)
    {
        this.debugModel = debugModel;
    }

    /**
     * Modifier for the 'errorLogEmailAddress' attribute.
     * 
     * @param errorLogEmailAddress
     *            the new errorLogEmailAddress value to set
     */
    public void setErrorLogEmailAddress(String errorLogEmailAddress)
    {
        this.errorLogEmailAddress = errorLogEmailAddress;
    }

    /**
     * Modifier for the 'errorLogEmailBody' attribute.
     * 
     * @param errorLogEmailBody
     *            the new errorLogEmailBody value to set
     */
    public void setErrorLogEmailBody(String errorLogEmailBody)
    {
        this.errorLogEmailBody = errorLogEmailBody;
    }

    /**
     * Modifier for the 'errorLogEmailSubject' attribute.
     * 
     * @param errorLogEmailSubject
     *            the new errorLogEmailSubject value to set
     */
    public void setErrorLogEmailSubject(String errorLogEmailSubject)
    {
        this.errorLogEmailSubject = errorLogEmailSubject;
    }

}
