package pt.digitalis.dif.utils.mail;

import java.util.Properties;

import pt.digitalis.utils.config.IConfigurations;
import pt.digitalis.utils.config.annotations.ConfigIgnore;

/**
 * @author Galaio da Silva <a href="mailto:jgalaio@digitalis.pt">jgalaio@digitalis.pt</a><br/>
 * @created May 24, 2012
 */
public interface IMailConfiguration {

    /**
     * Gets the configurations.
     * 
     * @return the configurations
     */
    public IConfigurations getConfigurations();

    /**
     * Inspector for the 'debugEnabled' attribute.
     * 
     * @return the debugEnabled value
     */
    public String getDebugEnabled();

    /**
     * Inspector for the 'defaultFromAddress' attribute.
     * 
     * @return the defaultFromAddress value
     */
    public String getDefaultFromAddress();

    /**
     * Get the encoding
     * 
     * @return encoding
     */
    public String getEncoding();

    /**
     * Inspector for the 'GapBetweenMails' attribute.
     * 
     * @return the gapBetweenMails value
     */
    public int getGapBetweenMails();

    /**
     * Inspector for the 'LimitMaxEmails' attribute.
     * 
     * @return the limitMaxEmails value
     */
    public int getLimitMaxEmails();

    /**
     * Inspector for the 'LimitTimeInterval' attribute.
     * 
     * @return the limitTimeInterval value
     */
    public int getLimitTimeInterval();

    /**
     * Inspector for the 'mailServer' attribute.
     * 
     * @return the mailServer value
     */
    public String getMailServer();

    /**
     * Inspector for the 'mailServerPassword' attribute.
     * 
     * @return the mailServerPassword value
     */
    public String getMailServerPassword();

    /**
     * Inspector for the 'mailServerPort' attribute.
     * 
     * @return the mailServerPort value
     */
    public int getMailServerPort();

    /**
     * Inspector for the 'mailServerUsername' attribute.
     * 
     * @return the mailServerUsername value
     */
    public String getMailServerUsername();

    /**
     * Inspector for the 'originalConfs' attribute.
     * 
     * @return the originalConfs value
     */
    @ConfigIgnore
    public Properties getOriginalConfs();

    /**
     * Inspector for the 'useSSL' attribute.
     * 
     * @return the useSSL value
     */
    public Boolean getUseSSL();

    /**
     * Modifier for the 'configurations' attribute.
     * 
     * @param configurations
     *            the new configurations value to set
     */
    public void setConfigurations(IConfigurations configurations);

    /**
     * Modifier for the 'debugEnabled' attribute.
     * 
     * @param debugEnabled
     *            the new debugEnabled value to set
     */
    public void setDebugEnabled(String debugEnabled);

    /**
     * Modifier for the 'defaultFromAddress' attribute.
     * 
     * @param defaultFromAddress
     *            the new defaultFromAddress value to set
     */
    public void setDefaultFromAddress(String defaultFromAddress);

    /**
     * Set the encoding
     * 
     * @param encoding
     *            the encoding
     */
    public void setEncoding(String encoding);

    /**
     * Modifier for the 'GapBetweenMails' attribute.
     * 
     * @param gapBetweenMails
     *            the new gapBetweenMails value to set
     */
    public void setGapBetweenMails(int gapBetweenMails);

    /**
     * Modifier for the 'LimitMaxEmails' attribute.
     * 
     * @param limitMaxEmails
     *            the new limitMaxEmails value to set
     */
    public void setLimitMaxEmails(int limitMaxEmails);

    /**
     * Modifier for the 'LimitTimeInterval' attribute.
     * 
     * @param limitTimeInterval
     *            the new limitTimeInterval value to set
     */
    public void setLimitTimeInterval(int limitTimeInterval);

    /**
     * Modifier for the 'mailServer' attribute.
     * 
     * @param mailServer
     *            the new mailServer value to set
     */
    public void setMailServer(String mailServer);

    /**
     * Modifier for the 'mailServerPassword' attribute.
     * 
     * @param mailServerPassword
     *            the new mailServerPassword value to set
     */
    public void setMailServerPassword(String mailServerPassword);

    /**
     * Modifier for the 'mailServerPort' attribute.
     * 
     * @param mailServerPort
     *            the new mailServerPort value to set
     */
    public void setMailServerPort(int mailServerPort);

    /**
     * Modifier for the 'mailServerUsername' attribute.
     * 
     * @param mailServerUsername
     *            the new mailServerUsername value to set
     */
    public void setMailServerUsername(String mailServerUsername);

    /**
     * Modifier for the 'originalConfs' attribute.
     * 
     * @param originalConfs
     *            the new originalConfs value to set
     */
    public void setOriginalConfs(Properties originalConfs);

    /**
     * Modifier for the 'useSSL' attribute.
     * 
     * @param useSSL
     *            the new useSSL value to set
     */
    public void setUseSSL(Boolean useSSL);

    /**
     * Write configuration
     * 
     * @throws Exception
     *             if an Exception occurrs
     */
    public void writeConfiguration() throws Exception;

}
