/**
 * 2009, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.utils.system;

import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

import pt.digitalis.utils.common.collections.IndexedHashMap;

/**
 * The Class SystemUtils.
 * 
 * @author Luis Pinto <a href="mailto:lpinto@digitalis.pt">lpinto@digitalis.pt</a><br/>
 * @created Sep 11, 2012
 */
public class SystemUtils {

    /** the JBoss version tag. */
    static private String jbossTagCache;

    /**
     * Gets the j boss version.
     * 
     * @return the JBoss version string
     */
    public static String getJBossVersion()
    {
        if (jbossTagCache == null)
        {
            Manifest manifest = null;
            Enumeration<URL> resEnum;
            try
            {
                resEnum = Thread.currentThread().getContextClassLoader().getResources(JarFile.MANIFEST_NAME);
                while (resEnum.hasMoreElements())
                {
                    URL url = resEnum.nextElement();
                    InputStream is = url.openStream();
                    if (is != null)
                    {
                        Manifest manifestTemp = new Manifest(is);
                        Attributes mainAttribs = manifestTemp.getMainAttributes();
                        String title = mainAttribs.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
                        if (title != null && title.toUpperCase().contains("JBOSS"))
                        {
                            manifest = manifestTemp;
                            break;
                        }
                    }
                }
            }
            catch (Exception e)
            {
                // Silently ignore wrong manifests on classpath?
            }

            if (manifest == null)
                jbossTagCache = "Unknown";
            else
            {
                jbossTagCache = manifest.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_TITLE) + " v."
                        + manifest.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
        }

        return jbossTagCache;
    }

    /**
     * Gets the system properties.
     * 
     * @return the system properties
     */
    public static Map<String, Object> getSystemProperties()
    {
        Map<String, Object> props = new IndexedHashMap<String, Object>();
        try
        {
            props.put("COMPUTERNAME", InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e)
        {
            props.put("COMPUTERNAME", System.getenv().get("COMPUTERNAME"));
        }

        String OS = System.getenv().get("OS");
        if (OS == null || "".equals(OS))
        {
            OS = System.getProperty("os.name") + " " + System.getProperty("os.version") + ","
                    + System.getProperty("os.arch");
        }

        props.put("OS", OS);
        props.put("USERDOMAIN", System.getenv().get("USERDOMAIN"));
        props.put("USERNAME", System.getenv().get("USERNAME"));

        if (System.getenv().get("PROCESSOR_ARCHITECTURE") != null)
        {
            props.put("PROCESSOR_ARCHITECTURE", System.getenv().get("PROCESSOR_ARCHITECTURE"));
        }
        else
        {
            props.put("PROCESSOR_ARCHITECTURE", ManagementFactory.getOperatingSystemMXBean().getArch());

        }

        props.put("PROCESSOR_IDENTIFIER", System.getenv().get("PROCESSOR_IDENTIFIER"));

        props.put("javaVersion", System.getProperty("java.vendor") + " (v." + System.getProperty("java.version") + ")"
                + " - VM: " + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + ","
                + System.getProperty("java.vm.vendor"));
        props.put("jBossVersion", getJBossVersion());

        props.put("totalMemory", Runtime.getRuntime().totalMemory() / 1024 / 1024 + " Mb");
        props.put("maxMemory", Runtime.getRuntime().maxMemory() / 1024 / 1024 + " Mb");
        props.put("freeMemory", Runtime.getRuntime().freeMemory() / 1024 / 1024 + " Mb");
        props.put("processorNumber", Runtime.getRuntime().availableProcessors());

        return props;
    }
}
