/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.codegen.templates;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import pt.digitalis.dif.codegen.CGAncillaries;
import pt.digitalis.dif.dem.CallbackType;
import pt.digitalis.dif.dem.interfaces.IService;
import pt.digitalis.dif.dem.interfaces.IStage;
import pt.digitalis.dif.dem.interfaces.IStageInstance;
import pt.digitalis.dif.dem.objects.EventType;
import pt.digitalis.dif.dem.objects.LicenseEditionType;
import pt.digitalis.dif.dem.objects.ViewObject;
import pt.digitalis.dif.dem.objects.ViewType;
import pt.digitalis.dif.dem.objects.parameters.IParameters;
import pt.digitalis.dif.exception.manager.RegistrationManagerException;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.utils.inspection.ReflectionUtils;
import pt.digitalis.utils.inspection.exception.AuxiliaryOperationException;

/**
 * This class is a template for the IStage interface method implementations. The CodeGen will copy these methods to a
 * new Proxy class for each stage. Some methods will be copied "as is", other will be tweaked. These Proxy classes are
 * intended to be Singletons kept by the {@link pt.digitalis.dif.dem.interfaces.IDEMRegistry}
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @created 2007/07/12
 */
public class StageCGTemplate implements IStage {

    /**
     * Relates the exception types with the stages for redirection purposes upon an exception raising. <K = Exception
     * FQN, V = stage id>
     */
    static private Map<String, String> errorStages;

    /**
     * Relates the exception types with the views for redirection purposes upon an exception raising. <K = Exception
     * FQN, V = Error view objects>
     */
    static public Map<String, ViewObject> errorViews;

    /** The list of registered event handlers */
    static private Map<EventType, List<String>> eventHandlers;

    /** The list of injected stages */
    static private List<String> injectedStages;

    /** The list of injected views */
    static private List<ViewObject> injectedViews;

    /** Controls the lazy initializations of this stage proxy... */
    static protected boolean isInitialized = false;

    /** The parameters object */
    private IParameters parameters;

    /**
     * Adds a new event id to the known handlers
     * 
     * @param type
     *            the event type to add
     * @param id
     *            the id of the event
     */
    protected void addEvent(EventType type, String id)
    {
        eventHandlers.get(type).add(id);
    }

    /**
     * Creates a new view object. For usage of the CG methods
     * 
     * @param engine
     *            the engine of the view
     * @param type
     *            the type of the view
     * @param target
     *            the target resource/template of the view
     * @param isDefault
     *            T if the view is the default view
     * @return the created view object
     */
    protected ViewObject createView(String engine, String type, String target, boolean isDefault)
    {
        return new ViewObject(engine, ViewType.valueOf(type), target, isDefault);
    }

    /** event handlers builder. Will be overridden in the CG if they exist */
    private void eventHandlersBuilder()
    {
        // By default do nothing
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.ICallback#getCallbackType()
     */
    public CallbackType getCallbackType()
    {
        return CallbackType.OFF;
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IStage#getDefaultErrorStage()
     */
    public IStage getDefaultErrorStage()
    {
        return CGAncillaries.CG_TO_BE_IMPLEMENTED_STAGE;
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IStage#getDefaultErrorView()
     */
    public ViewObject getDefaultErrorView()
    {
        return CGAncillaries.CG_TO_BE_IMPLEMENTED_VIEW;
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IStage#getDefaultView()
     */
    public ViewObject getDefaultView()
    {
        return CGAncillaries.CG_TO_BE_IMPLEMENTED_VIEW;
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IStage#getEventHandlers()
     */
    synchronized public Map<EventType, List<String>> getEventHandlers()
    {
        if (eventHandlers == null)
        {
            // Lazy loading. On first call will create the list using the CG generated builder
            eventHandlers = new HashMap<EventType, List<String>>();

            eventHandlers.put(EventType.FORM_SUBMIT, new ArrayList<String>());
            eventHandlers.put(EventType.FORM_SUBMIT_AJAX_REQUEST, new ArrayList<String>());
            eventHandlers.put(EventType.FORM_SUBMIT_SAVE_ACTION, new ArrayList<String>());
            eventHandlers.put(EventType.FORM_VALIDATION, new ArrayList<String>());
            eventHandlers.put(EventType.AJAX_REQUEST, new ArrayList<String>());
            eventHandlers.put(EventType.DOCUMENT_TYPE, new ArrayList<String>());

            eventHandlersBuilder();
        }

        return eventHandlers;
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IEntity#getID()
     */
    public String getID()
    {
        return CGAncillaries.CG_TO_BE_IMPLEMENTED_MESSAGE;
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IStage#getInjectedErrorStages()
     */
    synchronized public Map<String, String> getInjectedErrorStages()
    {
        if (errorStages == null)
        {
            // Lazy loading. On first call will create the list using the CG generated builder
            errorStages = new HashMap<String, String>();
            injectedErrorStagesBuilder();
        }

        return errorStages;
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IStage#getInjectedErrorViews()
     */
    synchronized public Map<String, ViewObject> getInjectedErrorViews()
    {
        if (errorViews == null)
        {
            errorViews = new HashMap<String, ViewObject>();
            injectedErrorViewsBuilder();
        }

        return errorViews;
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IStage#getInjectedStages()
     */
    synchronized public List<String> getInjectedStages()
    {

        if (injectedStages == null)
        {
            // Lazy loading. On first call will create the list using the CG generated builder
            injectedStages = new ArrayList<String>();
            injectedStagesBuilder();
        }

        return injectedStages;
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IStage#getInjectedViews()
     */
    synchronized public List<ViewObject> getInjectedViews()
    {
        if (injectedViews == null)
        {
            injectedViews = new ArrayList<ViewObject>();
            injectedViewsBuilder();
        }

        return injectedViews;
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IStage#getInstance()
     */
    synchronized public IStageInstance getInstance()
    {
        IStageInstance instance;

        try
        {
            Class<?> clazz = Class.forName(getStageInstanceClassName());
            instance = (IStageInstance) ReflectionUtils.instantiateObjectFromClass(clazz);
        }
        catch (AuxiliaryOperationException e)
        {
            // This should never happen. If it does DIF will show the exception. Here we return null.
            return null;
        }
        catch (ClassNotFoundException e)
        {
            // This should never happen. If it does DIF will show the exception. Here we return null.
            return null;
        }

        instance.setProxy(this);

        if (!isInitialized)
            lazyStageProxyInitialization(instance);

        return instance;
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IRegistrable#getLicenseEdition()
     */
    public LicenseEditionType getLicenseEdition()
    {
        return TemplateResources.getRegistrationManager().getStageEdition(this.getID());
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IStage#getMessageForLanguage(java.lang.String, java.lang.String)
     */
    public String getMessageForLanguage(String language, String messageID)
    {
        return getMessagesForLanguage(language).get(messageID);
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IStage#getMessagesForLanguage(java.lang.String)
     */

    public Map<String, String> getMessagesForLanguage(String language)
    {
        return TemplateResources.getMessageManager().getMessages(this, language);
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IEntity#getName()
     */
    public String getName()
    {
        return CGAncillaries.CG_TO_BE_IMPLEMENTED_MESSAGE;
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IEntity#getOriginalClassName()
     */
    public String getOriginalClassName()
    {
        return CGAncillaries.CG_TO_BE_IMPLEMENTED_MESSAGE;
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IStage#getOverridesStageID()
     */
    public String getOverridesStageID()
    {
        return null;
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IStage#getParameters()
     */
    @SuppressWarnings("static-access")
    synchronized public IParameters getParameters()
    {
        if (parameters == null)
        {
            parameters = getTemplateResources().getParametersInstance(getInstance());
            // TODO: Refactor the IParameterImpl so that we can access the parameter list with initializing a
            // StageInstance parameters.initialize(this);
        }

        return parameters;
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IStage#getService()
     */
    public IService getService()
    {
        return TemplateResources.getDEMManager().getService(CGAncillaries.CG_TO_BE_IMPLEMENTED_MESSAGE);
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IStage#getStageInstanceClassName()
     */
    public String getStageInstanceClassName()
    {
        return CGAncillaries.CG_TO_BE_IMPLEMENTED_MESSAGE;
    }

    /**
     * For usage of the CG methods
     * 
     * @return an instance of template resources
     */
    protected TemplateResources getTemplateResources()
    {
        return TemplateResources.getInstance();
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IEntity#getUID()
     */
    public String getUID()
    {
        return "STAGE:" + this.getID();
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IStage#hasAuthentication()
     */
    public boolean hasAuthentication()
    {
        return true;
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IStage#hasAuthenticationErrorInjection()
     */
    public boolean hasAuthenticationErrorInjection()
    {
        return false;
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IStage#hasAuthorization()
     */
    public boolean hasAuthorization()
    {
        return true;
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.ICallback#hasCallbackEnabled()
     */
    public boolean hasCallbackEnabled()
    {
        return false;
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IStage#hasInjectedContributions()
     */
    public boolean hasInjectedContributions()
    {
        return false;
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IStage#hasParameterErrorInjection()
     */
    public boolean hasParameterErrorInjection()
    {
        // By default returns false. If the stage implementation injects the parameter errors, that this is overwritten
        // with 'true'
        return false;
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IStage#hasValidationLogicForForm(java.lang.String)
     */
    public boolean hasValidationLogicForForm(String formName)
    {
        return this.getEventHandlers().get(EventType.FORM_VALIDATION).contains(formName);
    }

    /** Injected Error Stages builder. Will be overridden in the CG if stages are injected */
    private void injectedErrorStagesBuilder()
    {}

    /** Injected Views builder. Will be overridden in the CG if stages are injected */
    private void injectedErrorViewsBuilder()
    {}

    /** Injected Stages builder. Will be overridden in the CG if stages are injected */
    private void injectedStagesBuilder()
    {}

    /** Injected Views builder. Will be overridden in the CG if stages are injected */
    private void injectedViewsBuilder()
    {}

    /**
     * @see pt.digitalis.dif.dem.interfaces.IRegistrable#isRegistered()
     */
    public boolean isRegistered()
    {
        boolean result = this.getService().isRegistered();

        if (this.isRegistrable())
            result = TemplateResources.getRegistrationManager().isStageRegistered(getID());

        return result;
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IRegistrable#isRegistrable()
     */
    public boolean isRegistrable()
    {
        return TemplateResources.getRegistrationManager().isStageRegistrable(getID());
    }

    /**
     * The lazy initializations for all stages. Things that require all DEM entities to be previously initialized
     * 
     * @param stage
     *            the stage instance for accessing some stage properties in the initialization process
     */
    protected void lazyStageProxyInitialization(IStageInstance stage)
    { // FIXME: lazyStageProxyInitialization is generating errors
        /*
         * try { for (IParameter<?> parameter:
         * stage.getParameters().getAllAvailableParameters().getParameters().values()) if (parameter.getRules() != null
         * && parameter.getRules().size() > 0) for (IParameterRule<?> rule: parameter.getRules()) {
         * AbstractParameterRule<?> ruleInstance = (AbstractParameterRule<?>) rule; for (String linkedParameterID:
         * ruleInstance.getParameters()) getParameters().getAllAvailableParameters().getParameter(linkedParameterID)
         * .setReferencedInARuleFromAnotherParameter(true); } } catch (ParameterException e) {
         * DIFLogger.getLogger().info("Could not initialize stage parameters: " + e.getMessage()); }
         */
        isInitialized = true;
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IRegistrable#register(java.lang.String, java.lang.String)
     */
    public boolean register(String name, String key)
    {
        try
        {
            return TemplateResources.getRegistrationManager().registerStage(getID(), name, key);
        }
        catch (RegistrationManagerException e)
        {
            DIFLogger.getLogger().debug(e);
            return false;
        }
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IRegistrable#unregister()
     */
    public void unregister()
    {
        TemplateResources.getRegistrationManager().unregisterStage(getID());
    }
}