/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.controller.objects;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

import javax.servlet.http.HttpServletRequest;

import pt.digitalis.dif.controller.interfaces.IDIFRequest;
import pt.digitalis.dif.controller.interfaces.IDIFSession;
import pt.digitalis.dif.dem.interfaces.IStage;
import pt.digitalis.dif.dem.managers.IDEMManager;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.utils.ObjectFormatter;

/**
 * Implementation for {@link IDIFRequest}.
 * 
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @author Luis Pinto <a href="mailto:lpinto@digitalis.pt">lpinto@digitalis.pt</a>
 * @created 2007/03/16
 */
public class DIFRequest implements IDIFRequest {

    /** The key to the original request stored as an attribute. */
    final static public String ORIGINAL_REQUEST = "originalRequest";

    /** Ajax mode, false by default */
    private boolean ajaxMode = false;

    /**
     * The attribute collection with the values from the original request.
     */
    private Map<String, Object> attributes = new HashMap<String, Object>();

    /** The descriptor of the client */
    private ClientDescriptor client;

    /** Component mode, false by default */
    private boolean componentMode = false;

    /** The requested response format. */
    private String format;

    /** Help mode, false by default */
    private boolean helpMode = false;

    /**
     * The parameter collection with the values from the original request
     */
    private Map<String, Object> parameters = new HashMap<String, Object>();

    /** Popup mode, false by default */
    private boolean popupMode = false;

    /** REST action, if set in request */
    RESTAction restAction = null;

    /** REST call, false by default */
    private boolean restCall = false;

    /** The requested stage. */
    private String stage;

    /** Template mode, false by default */
    private boolean templateMode = false;

    /** The session. */
    private IDIFSession theSession;

    /**
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#addAttribute(String, Object)
     */
    public void addAttribute(String attributeName, Object attributeValue)
    {
        attributes.put(attributeName, attributeValue);
    }

    /**
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#addParameter(String, Object)
     */
    public void addParameter(String parameterName, Object parameterValue)
    {
        parameters.put(parameterName.toLowerCase(), parameterValue);
    }

    /**
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#getAttribute(java.lang.String)
     */
    public Object getAttribute(String name)
    {
        return this.attributes.get(name);
    }

    /**
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#getAttributes()
     */
    public Map<String, Object> getAttributes()
    {
        return this.attributes;
    }

    /**
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#getClient()
     */
    public ClientDescriptor getClient()
    {
        return client;
    }

    /**
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#getFormat()
     */
    public String getFormat()
    {
        return format;
    }

    /**
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#getParameter(java.lang.String)
     */
    public Object getParameter(String name)
    {
        return this.parameters.get(name.toLowerCase());
    }

    /**
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#getParameterRawValue(java.lang.String)
     */
    public String getParameterRawValue(String parameterID)
    {
        return ((HttpServletRequest) this.getAttribute(DIFRequest.ORIGINAL_REQUEST)).getParameter(parameterID);
    }

    /**
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#getParameters()
     */
    public Map<String, Object> getParameters()
    {
        return this.parameters;
    }

    /**
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#getRestAction()
     */
    public RESTAction getRestAction()
    {
        return restAction;
    }

    /**
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#getSession()
     */
    public IDIFSession getSession()
    {
        return this.theSession;
    }

    /**
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#getStage()
     */
    public String getStage()
    {
        return stage;
    }

    /**
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#getStageProxy()
     */
    public IStage getStageProxy()
    {
        return DIFIoCRegistry.getRegistry().getImplementation(IDEMManager.class).getStage(getStage());
    }

    /**
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#isAjaxMode()
     */
    public boolean isAjaxMode()
    {
        return ajaxMode;
    }

    /**
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#isComponentMode()
     */
    public boolean isComponentMode()
    {
        return componentMode;
    }

    /**
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#isHelpMode()
     */
    public boolean isHelpMode()
    {
        return helpMode;
    }

    /**
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#isPopupMode()
     */
    public boolean isPopupMode()
    {
        return popupMode;
    }

    /**
     * Inspector for the 'restCall' attribute.
     * 
     * @return the restCall value
     */
    public boolean isRestCall()
    {
        return restCall;
    }

    /**
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#isTemplateMode()
     */
    public boolean isTemplateMode()
    {
        return templateMode;
    }

    /**
     * Modifier for the 'ajaxMode' attribute.
     * 
     * @param ajaxMode
     *            the new ajaxMode value to set
     */
    public void setAjaxMode(boolean ajaxMode)
    {
        this.ajaxMode = ajaxMode;
    }

    /**
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#setAttributes(Map)
     */
    public void setAttributes(Map<String, Object> attributes)
    {
        this.attributes = attributes;
    }

    /**
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#setClient(ClientDescriptor)
     */
    public void setClient(ClientDescriptor client)
    {
        this.client = client;
    }

    /**
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#setComponentMode(boolean)
     */
    public void setComponentMode(boolean componentMode)
    {
        this.componentMode = componentMode;
    }

    /**
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#setFormat(java.lang.String)
     */
    public void setFormat(String format)
    {
        this.format = format;
    }

    /**
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#setHelpMode(boolean)
     */
    public void setHelpMode(boolean helpMode)
    {
        this.helpMode = helpMode;
    }

    /**
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#setParameters(Map)
     */
    public void setParameters(Map<String, Object> parameters)
    {
        for (Entry<String, Object> entry: parameters.entrySet())
            addParameter(entry.getKey().toLowerCase(), entry.getValue());
    }

    /**
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#setPopupMode(boolean)
     */
    public void setPopupMode(boolean popupMode)
    {
        this.popupMode = popupMode;
    }

    /**
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#setRestAction(pt.digitalis.dif.controller.objects.RESTAction)
     */
    public void setRestAction(RESTAction restAction)
    {
        this.restAction = restAction;
    }

    /**
     * Modifier for the 'restCall' attribute.
     * 
     * @param restCall
     *            the new restCall value to set
     */
    public void setRestCall(boolean restCall)
    {
        this.restCall = restCall;
    }

    /**
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#setSession(pt.digitalis.dif.controller.interfaces.IDIFSession)
     */
    public void setSession(IDIFSession session)
    {
        this.theSession = session;

    }

    /**
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#setStage(String)
     */
    public void setStage(String newStage)
    {
        this.stage = newStage;
    }

    /**
     * @see pt.digitalis.dif.controller.interfaces.IDIFRequest#setTemplateMode(boolean)
     */
    public void setTemplateMode(boolean templateMode)
    {
        this.templateMode = templateMode;
    }

    /**
     * Returns the Request object in a human-readable form.
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString()
    {

        ObjectFormatter formatter = new ObjectFormatter();
        formatter.addItem("Client", client);
        formatter.addItem("stage", stage);
        formatter.addItem("Template Mode", templateMode);
        formatter.addItem("Component Mode", componentMode);
        formatter.addItem("Popup Mode", isPopupMode());
        formatter.addItem("REST URL Mode", isRestCall());
        formatter.addItem("Help Mode", helpMode);
        formatter.addItem("Session", theSession);

        Map<String, Object> allowedAttributes = new HashMap<String, Object>();
        allowedAttributes.putAll(attributes);
        allowedAttributes.remove("PageContentAttribute");
        formatter.addItem("Attributes", allowedAttributes);

        Map<String, Object> allowedParams = new HashMap<String, Object>();
        allowedParams.putAll(parameters);
        if (allowedParams.containsKey(PASSWORD_PARAMETER_ID))
            allowedParams.put(PASSWORD_PARAMETER_ID, "*****");
        if (allowedParams.containsKey("password"))
            allowedParams.put("password", "*****");
        formatter.addItem("Parameters", allowedParams);

        return formatter.getFormatedObject();
    }
}
