/** 2007, Digitalis Informatica. All rights reserved.
 * 
 * Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1
 * 2780-666 Paco de Arcos
 * Telefone: (351) 21 4408990
 * Fax: (351) 21 4408999
 * http://www.digitalis.pt 
 */

package pt.digitalis.dif.controller.security.managers;

import pt.digitalis.dif.controller.interfaces.IDIFSession;
import pt.digitalis.dif.exception.security.AuthenticationManagerException;

/**
 * Defines the behavior for a session manager.
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a><br/>
 * @created Dec 11, 2007
 */
public interface ISessionManager {

    /**
     * Checks if a given session is registered on the framework.
     * 
     * @param sessionID
     *            the session id
     * @return T if a session with this ID is present and active.
     */
    public boolean isSessionPresent(String sessionID);

    /**
     * Gets a managed session
     * 
     * @param sessionID
     * @return the session object or null if non-existent
     */
    public IDIFSession getSession(String sessionID);

    /**
     * Creates a new session. If existent returns the matching identifier existing session
     * 
     * @param sessionID
     *            the session id to create
     * @return the created session
     */
    public IDIFSession createSession(String sessionID);

    /**
     * Updates an existent session
     * 
     * @param session
     *            the session to update
     * @return T if the session existed and was updated
     */
    public boolean update(IDIFSession session);

    /**
     * Performs the log in of a user with a given id on the framework.
     * 
     * @param sessionID
     *            the session identifier
     * @param userID
     *            the id of the user to log in
     * @param password
     *            the password for the user
     * @return the updated session object
     * @throws AuthenticationManagerException
     *             if the authentication manager can't be accessed to validate the user's credentials
     */
    public IDIFSession logIn(String sessionID, String userID, String password) throws AuthenticationManagerException;

    /**
     * Performs the log out of a user with a given id on the framework.
     * 
     * @param sessionID
     *            the session id to log out
     * @return the updated session object
     */
    public IDIFSession logOut(String sessionID);
}
