/** 2007, Digitalis Informatica. All rights reserved.
 * 
 * Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1
 * 2780-666 Paco de Arcos
 * Telefone: (351) 21 4408990
 * Fax: (351) 21 4408999
 * http://www.digitalis.pt 
 */

package pt.digitalis.dif.controller.security.objects;

import pt.digitalis.dif.dem.Entity;
import pt.digitalis.dif.dem.interfaces.IStage;

/**
 * Defines the behavior a user must provide regarding authorization.
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a><br/>
 * @created 2007/12/04
 */
public interface IUserAuthorization {

    /**
     * Checks if the user can access a given resource.
     * 
     * @param resourceType
     *            the resource (entity) type.
     * @param resourceId
     *            the id of the resource to check access
     * @return T if the user can access the resource, F otherwise
     */
    public boolean canAccess(Entity resourceType, String resourceId);

    /**
     * Checks if the user can access a given stage. Will parse the DEM for inherited grants
     * 
     * @param stage
     *            the stage to check
     * @return T if the user can access the stage, F otherwise
     */
    public boolean canAccess(IStage stage);
}
