/**
 * 2014, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.dem.managers;

import pt.digitalis.dif.dem.interfaces.ICustomFormDefinition;
import pt.digitalis.dif.dem.interfaces.IStageInstance;

/**
 * This feature manages form configurations by the user, either a general configurations or a specific instance
 * configuration (associated with a business key provided by the developer. i.e. a custom form for each account)
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 29/01/2014
 */
public interface ICustomFormManager {

    /**
     * Reads from the underlying repository the current form customized configuration
     * 
     * @param stageInstance
     *            the current stage instance from where the form submited will be infered
     * @param businessConfigurationID
     *            the business form instance ID
     * @return the current configuration for the given form
     */
    public ICustomFormDefinition getConfiguration(IStageInstance stageInstance, String businessConfigurationID);

    /**
     * Reads from the underlying repository the current form customized configuration
     * 
     * @param stageID
     *            the form stage ID
     * @param formName
     *            the form name
     * @param businessConfigurationID
     *            the business form instance ID
     * @return the current configuration for the given form
     */
    public ICustomFormDefinition getConfiguration(String stageID, String formName, String businessConfigurationID);

    /**
     * Updates the given form configuration in the underlying repository
     * 
     * @param definition
     *            the form definition to save
     */
    public void updateConfiguration(ICustomFormDefinition definition);
}
