/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.dem.objects;

import java.util.Date;

/**
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created Nov 1, 2007
 */
public interface ILicense {

    /**
     * Generates full version key
     * 
     * @param client
     *            the client name to the key association
     * @param entity
     *            the entity to register
     * @param date
     *            date to use in the encryption
     * @param edition
     *            The edition type
     * @return the generated full version key
     */
    public String generateKey(String client, String entity, String date, LicenseEditionType edition);

    /**
     * Returns the License Edition
     * 
     * @return {@link LicenseEditionType}
     */
    public LicenseEditionType getEdition();

    /**
     * Checks if the current license has expired
     * 
     * @return The expiration date, or null it it is a final license
     */
    public Date getExpirationDate();

    /**
     * @return the key
     */
    public String getKey();

    /**
     * @return the name
     */
    public String getName();

    /**
     * Checks if the current license has an expiration date
     * 
     * @return T if it has
     */
    public boolean hasExpirationDate();

    /**
     * Checks if the current license has expired
     * 
     * @return T if the expiration date has passed
     */
    public boolean hasExpired();

    /**
     * Checks if it is registered
     * 
     * @return T if the key exists and is correct
     */
    public boolean isRegistered();

    /**
     * Checks if the element is registrable
     * 
     * @return T if it is registrable
     */
    public boolean isRegistrable();

    /**
     * Create the registration
     * 
     * @param key
     *            the key to register
     * @param entityId
     * @return the registered record
     */
    public boolean register(String key, String entityId);

    /**
     * @param name
     *            the name to set
     */
    public void setName(String name);

    /**
     * Sets the registrability of this element
     * 
     * @param registrable
     *            the registrability to set
     */
    public void setRegistrable(boolean registrable);

    /**
     * Delete the registration
     */
    public void unregister();
}
