/**
 * 2008, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.dem.objects.issues;

import java.util.Map;

import pt.digitalis.dif.controller.interfaces.IDIFContext;

/**
 * Usage issue bean.
 * 
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a><br/>
 * @created 2008/11/13
 */
public class UsageIssue {

    /**  */
    private IDIFContext context;

    /** discarded by the developer so the wine goes away */
    private boolean discarded = false;

    /** The exception that might be associated to the issue. */
    private Exception exception;

    /** The issue description. */
    private String issueDescription;

    /** The issue description. */
    private String issuePlainDescription;

    /** The issue scope. */
    private IssueScope issueScope;

    /** The issue description. */
    private String issueSmallDescription;

    /** The issue type. */
    private IssueType issueType;

    /** The location where the issue happened. */
    private String location;

    /** The issue JavaScript code to call to show the details */
    private Map<String, String> showDetailsContent;

    /** the private UID */
    private String UID;

    /**
     * Inspector for the 'context' attribute.
     * 
     * @return the context value
     */
    public IDIFContext getContext()
    {
        return context;
    }

    /**
     * Inspector for the 'exception' attribute.
     * 
     * @return the exception value
     */
    public Exception getException()
    {
        return this.exception;
    }

    /**
     * Inspector for the 'issueDescription' attribute.
     * 
     * @return the issueDescription value
     */
    public String getIssueDescription()
    {
        return this.issueDescription;
    }

    /**
     * Inspector for the 'issuePlainDescription' attribute.
     * 
     * @return the issuePlainDescription value
     */
    public String getIssuePlainDescription()
    {
        return this.issuePlainDescription == null ? this.getIssueDescription() : this.issuePlainDescription;
    }

    /**
     * Inspector for the 'issueScope' attribute.
     * 
     * @return the issueScope value
     */
    public IssueScope getIssueScope()
    {
        return this.issueScope;
    }

    /**
     * Inspector for the 'issueSmallDescription' attribute.
     * 
     * @return the issueSmallDescription value
     */
    public String getIssueSmallDescription()
    {
        return this.issueSmallDescription == null ? this.getIssuePlainDescription() : this.issueSmallDescription;
    }

    /**
     * Inspector for the 'issueType' attribute.
     * 
     * @return the issueType value
     */
    public IssueType getIssueType()
    {
        return this.issueType;
    }

    /**
     * Inspector for the 'location' attribute.
     * 
     * @return the location value
     */
    public String getLocation()
    {
        return this.location;
    }

    /**
     * Inspector for the 'showDetailsContent' attribute.
     * 
     * @return the showDetailsContent value
     */
    public Map<String, String> getShowDetailsContent()
    {
        return showDetailsContent;
    }

    /**
     * Inspector for the 'UID' attribute.
     * 
     * @return the uID value
     */
    public String getUID()
    {
        return UID;
    }

    /**
     * Inspector for the 'discarded' attribute.
     * 
     * @return the discarded value
     */
    public boolean isDiscarded()
    {
        return discarded;
    }

    /**
     * Modifier for the 'context' attribute.
     * 
     * @param context
     *            the new context value to set
     */
    public void setContext(IDIFContext context)
    {
        this.context = context;
    }

    /**
     * Modifier for the 'discarded' attribute.
     * 
     * @param discarded
     *            the new discarded value to set
     */
    public void setDiscarded(boolean discarded)
    {
        this.discarded = discarded;
    }

    /**
     * Modifier for the 'exception' attribute.
     * 
     * @param exception
     *            the new exception value to set
     */
    public void setException(Exception exception)
    {
        this.exception = exception;
    }

    /**
     * Modifier for the 'issueDescription' attribute.
     * 
     * @param issueDescription
     *            the new issueDescription value to set
     */
    public void setIssueDescription(String issueDescription)
    {
        this.issueDescription = issueDescription;
    }

    /**
     * Modifier for the 'issuePlainDescription' attribute.
     * 
     * @param issuePlainDescription
     *            the new issuePlainDescription value to set
     */
    public void setIssuePlainDescription(String issuePlainDescription)
    {
        this.issuePlainDescription = issuePlainDescription;
    }

    /**
     * Modifier for the 'issueScope' attribute.
     * 
     * @param issueScope
     *            the new issueScope value to set
     */
    public void setIssueScope(IssueScope issueScope)
    {
        this.issueScope = issueScope;
    }

    /**
     * Modifier for the 'issueSmallDescription' attribute.
     * 
     * @param issueSmallDescription
     *            the new issueSmallDescription value to set
     */
    public void setIssueSmallDescription(String issueSmallDescription)
    {
        this.issueSmallDescription = issueSmallDescription;
    }

    /**
     * Modifier for the 'issueType' attribute.
     * 
     * @param issueType
     *            the new issueType value to set
     */
    public void setIssueType(IssueType issueType)
    {
        this.issueType = issueType;
    }

    /**
     * Modifier for the 'location' attribute.
     * 
     * @param location
     *            the new theEntity value to set
     */
    public void setLocation(String location)
    {
        this.location = location;
    }

    /**
     * Modifier for the 'showDetailsContent' attribute.
     * 
     * @param showDetailsContent
     *            the new showDetailsContent value to set
     */
    public void setShowDetailsContent(Map<String, String> showDetailsContent)
    {
        this.showDetailsContent = showDetailsContent;
    }

    /**
     * Modifier for the 'UID' attribute.
     * 
     * @param uID
     *            the new uID value to set
     */
    public void setUID(String uID)
    {
        UID = uID;
    }

    /**
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString()
    {
        final String NEW_LINE = "\n";
        final String BOUNDARY = "----------------------------------------------------------------------";

        StringBuffer result = new StringBuffer();

        if (getIssueType() != null)
            result.append("Issue type: " + getIssueType() + NEW_LINE);

        if (getIssueScope() != null)
            result.append("Issue scope: " + getIssueScope() + NEW_LINE);

        if (getIssueDescription() != null)
            result.append("Issue description: " + getIssueDescription() + NEW_LINE);

        if (getLocation() != null)
            result.append("Location: " + getLocation() + NEW_LINE);

        if (getException() != null)
            result.append("Associated exception: " + getException() + NEW_LINE);

        // If there's data to print add boundaries
        if (result.length() > 0)
        {
            result.insert(0, NEW_LINE + BOUNDARY + NEW_LINE);
            result.append(BOUNDARY);
        }

        return result.toString();
    }
}
