package pt.digitalis.dif.dem.objects.parameters.constraints.impl;

import java.util.HashMap;
import java.util.Map;

import pt.digitalis.dif.dem.interfaces.IStageInstance;
import pt.digitalis.utils.common.StringUtils;

/**
 * @author Galaio da Silva <a href="mailto:jgalaio@digitalis.pt">jgalaio@digitalis.pt</a><br/>
 * @created Jul 27, 2010
 */
public class ParameterConstraintEmailImpl extends ParameterConstraintRegexImpl {

    /** */
    private static final String MAIL_REGEX_JAVA = "^([\\w-]+(?:\\.[\\w-]+)*)@((?:[\\w-]+\\.)*\\w[\\w-]{0,66})\\.([a-z]{2,6}(?:\\.[a-z]{2})?)$";

    /** */
    private static final String MAIL_REGEX_JAVASCRIPT = "/^(([^<>()[\\]\\\\.,;:\\s@\\\"]+(\\.[^<>()[\\]\\\\.,;:\\s@\\\"]+)*)|(\\\".+\\\"))@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\])|(([a-zA-Z\\-0-9]+\\.)+[a-zA-Z]{2,}))$/";

    /**
     * @see pt.digitalis.dif.dem.objects.parameters.constraints.impl.ParameterConstraintRegexImpl#configureConstraint(java.lang.String)
     */
    @Override
    public void configureConstraint(String configurationString)
    {
        this.regexJava = MAIL_REGEX_JAVA;
        this.regexJavaScript = MAIL_REGEX_JAVASCRIPT;
    }

    /**
     * @see pt.digitalis.dif.dem.objects.parameters.constraints.impl.ParameterConstraintRegexImpl#getErrorMessageValues(boolean)
     */
    @Override
    protected Map<String, String> getErrorMessageValues(boolean parseValues)
    {
        Map<String, String> substitutions = new HashMap<String, String>();

        if (parseValues)
        {
            substitutions.put("value", lastTestedValue);
        }

        return substitutions;
    }

    /**
     * @see pt.digitalis.dif.dem.objects.parameters.constraints.impl.ParameterConstraintRegexImpl#validateConstraint(java.lang.String,
     *      pt.digitalis.dif.dem.interfaces.IStageInstance)
     */
    @Override
    public boolean validateConstraint(String value, IStageInstance stageInstance)
    {
        boolean result = super.validateConstraint(value, stageInstance);

        return result && (StringUtils.isBlank(value) || ((value.indexOf(".") > 2) && (value.indexOf("@") > 0)));
    }

}
