/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */
package pt.digitalis.dif.dem.objects.parameters.constraints.impl.numeric;

import java.util.ArrayList;
import java.util.List;

import pt.digitalis.dif.dem.interfaces.IStageInstance;
import pt.digitalis.dif.dem.objects.parameters.constraints.AbstractParameterConstraint;

/**
 * Base implementation for numeric parameter constraints
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @created Nov 16, 2007
 */
public abstract class AbstractNumericParameterConstraint extends AbstractParameterConstraint {

    /** Supported classes by numeric constraints */
    @SuppressWarnings("serial")
    final static private List<String> supportedClasses = new ArrayList<String>() {

        {
            add(Byte.class.getCanonicalName());
            add(Integer.class.getCanonicalName());
            add(Long.class.getCanonicalName());
            add(Double.class.getCanonicalName());

            add(byte.class.getCanonicalName());
            add(int.class.getCanonicalName());
            add(long.class.getCanonicalName());
            add(double.class.getCanonicalName());
        }
    };

    /**
     * @see pt.digitalis.dif.dem.objects.parameters.constraints.IParameterConstraint#isSupportedClass(java.lang.Class)
     */
    public boolean isSupportedClass(Class<?> clazz)
    {
        return supportedClasses.contains(clazz.getCanonicalName());
    }

    /**
     * Validate method with the value converted to a Double
     * 
     * @param value
     *            the value to compare
     * @param stageInstance
     *            the current stage in execution
     * @return T if the constraint is valid
     */
    abstract public boolean validateConstraint(Double value, IStageInstance stageInstance);

    /**
     * @see pt.digitalis.dif.dem.objects.parameters.constraints.IParameterConstraint#validateConstraint(java.lang.String,
     *      pt.digitalis.dif.dem.interfaces.IStageInstance)
     */
    public boolean validateConstraint(String value, IStageInstance stageInstance)
    {

        return (value == null || validateConstraint(new Double(value), stageInstance));
    }
}
