/** 2007, Digitalis Informatica. All rights reserved.
 *
 * Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1
 * 2780-666 Paco de Arcos
 * Telefone: (351) 21 4408990
 * Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.dem.objects.parameters.errors;

import java.util.ArrayList;
import java.util.List;

import pt.digitalis.dif.dem.objects.parameters.IParameter;
import pt.digitalis.dif.utils.ObjectFormatter;

/**
 * A list of parameter errors for a given parameter
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 */
public class ParameterErrorList {

    /** The parameter to witch the errors refer to */
    private IParameter<?> parameter;

    /** The value that was attempted to pass to the parameter */
    private Object attemptedValue;

    /**
     * The list of errors for the given parameter
     */
    private List<ParameterError> errorList = new ArrayList<ParameterError>();

    /**
     * Default constructor
     *
     * @param parameter
     *            the parameter that caused the error
     * @param attemptedValue
     *            the value that was attempted to pass to the parameter
     */
    public ParameterErrorList(IParameter<?> parameter, Object attemptedValue) {
        this.parameter = parameter;
        this.attemptedValue = attemptedValue;
    }

    /**
     * @return the errorList
     */
    public List<ParameterError> getErrorList() {
        return errorList;
    }

    /**
     * @param errorList
     *            the errorList to set
     */
    public void setErrorList(List<ParameterError> errorList) {
        this.errorList = errorList;
    }

    /**
     * @param errorList
     *            the errorList to add
     */
    public void addErrorList(List<ParameterError> errorList) {
        this.errorList.addAll(errorList);
    }

    /**
     * Adds an error to the list
     *
     * @param error
     *            the error to add
     */
    public void addError(ParameterError error) {
        this.errorList.add(error);
    }

    /**
     * @return the parameter
     */
    public IParameter<?> getParameter() {
        return parameter;
    }

    /**
     * @return the attemptedValue
     */
    public Object getAttemptedValue() {
        return attemptedValue;
    }

    /**
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        ObjectFormatter formatter = new ObjectFormatter();
        formatter.addItem("Parameter", parameter);
        formatter.addItem("Attempted Value", attemptedValue);
        formatter.addItem("Error List", errorList);

        return formatter.getFormatedObject();
    }
}
